% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/searchSDF.R
\name{searchSDF}
\alias{searchSDF}
\title{EdSurvey Codebook Search}
\usage{
searchSDF(string, data, fileFormat = NULL, levels = FALSE)
}
\arguments{
\item{string}{a character string to search for in the database connection object (\code{data}).
Note that the function will search the student, school,
and teacher datasets (if applicable) for a matching character string in the codebook.}

\item{data}{an \code{edsurvey.data.frame}, a \code{light.edsurvey.data.frame}, or
an \code{edsurvey.data.frame.list}}

\item{fileFormat}{a character string indicating the data source to search for variables.
The default \code{NULL} argument searches the student, school, and teacher codebooks.}

\item{levels}{a logical value; set to \code{TRUE} to return a snapshot of the levels in
an \code{edsurvey.data.frame}}
}
\value{
a \ifelse{latex}{\code{data.frame}}{\code{\link[base]{data.frame}}} that shows the variable names, labels,
                  and levels (if applicable) from an \code{edsurvey.data.frame} or a \code{light.edsurvey.data.frame} based on a matching character string.
}
\description{
Retrieve variable names and labels for an \code{edsurvey.data.frame},
a \code{light.edsurvey.data.frame}, or an \code{edsurvey.data.frame.list}
using character string matching
}
\examples{
# read in the example data (generated, not real student data)
sdf <- readNAEP(system.file("extdata/data", "M36NT2PM.dat", package="NAEPprimer"))

# search both the student and school files by a character string
searchSDF(string="book", data=sdf)

# search only the student files by a character string
searchSDF(string="algebra", data=sdf, fileFormat="student")

# search both the student and school files and return a glimpse of levels
searchSDF(string="value", data=sdf, levels=TRUE)

# save the search as an object to return a full data.frame of search
ddf <- searchSDF(string="value", data=sdf, levels=TRUE)
ddf
}
\author{
Michael Lee
}
