% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/edsurveyTable2pdf.R
\name{edsurveyTable2pdf}
\alias{edsurveyTable2pdf}
\title{PDF File From an edsurveyTable}
\usage{
edsurveyTable2pdf(
  data,
  formula,
  caption = NULL,
  filename = "",
  toCSV = "",
  returnMeans = TRUE,
  estDigits = 2,
  seDigits = 3
)
}
\arguments{
\item{data}{the result of a call to \code{\link{edsurveyTable}}}

\item{formula}{a formula of the form \code{LHS ~ RHS} to cast the \code{edsurveyTable}
results from long format to wide format. This formula takes the form
\code{LHS ~ RHS} (e.g., \code{var1 + var2 ~ var3}).
The order of the entries in the formula is essential.}

\item{caption}{character vector of length one or two containing the table's caption or title.
If the length is two, the second item is the \dQuote{short caption} used when LaTeX generates
a \code{List of Tables}.
Set to \code{NULL} to suppress the caption. Default value is \code{NULL}.}

\item{filename}{a character string containing filenames and paths. By default (\code{filename = ""}),
table will be saved in the working directory (\code{getwd()}).
Use \code{filename = "CONSOLE"} to
print LaTeX code in R console without generating a PDF file.}

\item{toCSV}{a character string containing filenames and paths of .csv table output.
\code{""} indicates no .csv output. \code{toCSV} is
independent to \code{filename}, so both
a csv file and PDF file would be generated if both \code{filename}
and \code{toCSV} were specified.}

\item{returnMeans}{a logical value set to \code{TRUE} (the default) to generate a PDF with
the \code{MEAN} and \code{SE(MEAN)}. It is set to \code{FALSE} to generate a PDF with
the \code{PCT} and \code{SE(PCT)}. See Value
in \code{\link[EdSurvey]{edsurveyTable}}.}

\item{estDigits}{an integer indicating the number of decimal places to be used for estimates.
Negative values are allowed. See Details.}

\item{seDigits}{an integer indicating the number of decimal places to be used for standard errors.
Negative values are allowed.}
}
\description{
Produces the LaTeX code and compiles to a PDF file from the \code{edsurveyTable} results.
}
\details{
Rounding to a negative number of digits means rounding to a power of 10,
so, for example, \code{estDigits = -2} rounds estimates to the nearest hundred.
}
\note{
For more details, see the vignette titled
\href{https://www.air.org/sites/default/files/EdSurvey-LaTeXtables.pdf}{\emph{Producing \code{LaTeX} Tables From \code{edsurveyTable} Results With \code{edsurveyTable2pdf}}}.
}
\examples{
\dontrun{
# read in the example data (generated, not real student data)
sdf <- readNAEP(system.file("extdata/data", "M36NT2PM.dat", package="NAEPprimer"))

# create a table with composite scores by dsex and b017451
est1 <- edsurveyTable(composite ~ dsex + b017451, sdf)

# create a table with csv output
edsurveyTable2pdf(data = est1, 
                  formula = b017451~dsex, 
                  toCSV = "C:/example table.csv",
                  filename = "C:/example table.pdf",
                  returnMeans = FALSE)

# create a pdf file using the default subject scale or subscale
# and keep two digits for estimates and three digits for SE after decimal point
edsurveyTable2pdf(est1, b017451~dsex, 
                  returnMeans = TRUE, estDigits = 2, seDigits = 3)

# create a pdf file using the percentage of students at the 
# aggregation level specified by \code{pctAggregationLevel}
# output will be saved as "C:/example table.pdf"
edsurveyTable2pdf(est1, 
                  b017451~dsex, 
                  "C:/example table.pdf",
                  returnMeans = FALSE)
}
}
\author{
Huade Huo
}
