% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elr_predict.R
\name{elrPredict}
\alias{elrPredict}
\title{Predict Conditional Effects}
\usage{
elrPredict(obj, newdata = NULL)
}
\arguments{
\item{obj}{Object of class \code{effectlite}.}

\item{newdata}{An optional data.frame, containing the same continuous and 
categorical covariates as used when fitting the EffectLiteR model in
obj. Only covariates (and neither the dependent variable nor indicators for 
latent variables) should be included.}
}
\value{
Object of class \code{"data.frame"}.
}
\description{
Predicts conditional treatment effects based on a fitted EffectLiteR model.
}
\examples{
m1 <- effectLite(y="dv", z=c("z1"), k=c("k1","kateg2"), x="x", 
control="control", data=example01)
newdata <- data.frame(k1="male", kateg2="1", z1=2)
elrPredict(m1, newdata)
}

