% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_docu.R
\docType{data}
\name{insolvency}
\alias{insolvency}
\title{Insolvency data}
\format{A data frame with 1224 observations on the following 16 variables.
\describe{ 
\item{Insolvency}{Survival of firms in ordered categories
with levels \code{1} < \code{2} < \code{3} < \code{4} < \code{5} < \code{6}
< \code{7}} 
\item{Sector}{Economic Sector with levels
\code{industry}, \code{commerce} and \code{service industry}}
\item{Legal}{Legal form with levels \code{small trade}, \code{one
man business}, \code{GmBH} and \code{GbR, KG, OHG}}
\item{Location}{Location with levels \code{residential area} and
\code{business area}} 
\item{New_Foundation}{New Foundation or
take-over with levels \code{new foundation} and \code{take-over}}
\item{Pecuniary_Reward}{Pecuniary reward with levels \code{main} and
\code{additional}} 
\item{Seed_Capital}{Seed capital with levels
\code{< 25000} and \code{> 25000}} 
\item{Equity_Capital}{Equity capital with levels \code{no} and \code{yes}}
\item{Debt_Capital}{Debt capital with levels \code{no} and
\code{yes}} 
\item{Market}{Market with levels \code{local} and
\code{national}} 
\item{Clientele}{Clientele with levels \code{wide
spread} and \code{small}} 
\item{Degree}{Educational level with
levels \code{no A-levels} and \code{A-Levels}} 
\item{Gender}{Gender with levels \code{female} and \code{male}}
\item{Experience}{Professional experience with levels \code{< 10
years} and \code{> 10 years}} 
\item{Employees}{Number of employees
with levels \code{0 or 1} and \code{> 2}} 
\item{Age}{Age of the founder at formation of the company} }}
\source{
Muenchner Gruender Studie
}
\description{
The data set originates from the Munich founder study. The data were
collected on business founders who registered their new companies at the
local chambers of commerce in Munich and surrounding administrative
districts. The focus was on survival of firms measured in 7 categories, the
first six represent failure in intervals of six months, the last category
represents survival time beyond 36 months.
}
\examples{

\dontrun{
data(insolvency)
insolvency$Age <- scale(insolvency$Age)

my_formula <- Insolvency ~ Age + Gender

m_acat <- vglm(my_formula, data = insolvency,family = acat())
m_cratio <- vglm(my_formula, data = insolvency,family = cratio())
m_sratio <- vglm(my_formula, data = insolvency,family = sratio())
m_cumulative <- vglm(my_formula, data = insolvency,family = cumulative())

summary(m_acat)
effectstars(m_acat, p.values = TRUE)

summary(m_cratio)
effectstars(m_cratio, p.values = TRUE)

summary(m_sratio)
effectstars(m_sratio, p.values = TRUE)

summary(m_cumulative)
effectstars(m_cumulative, p.values = TRUE)
}

}
\references{
Bruederl, J. and Preisendoerfer,
P. and Ziegler, R. (1996): \emph{Der Erfolg neugegruendeter Betriebe: 
eine empirische Studie zu den Chancen und Risiken von
Unternehmensgruendungen}, Duncker & Humblot.
}
\keyword{datasets}
\keyword{ordinal}
\keyword{response}
