% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EigenR.R
\name{Eigen_sqrt}
\alias{Eigen_sqrt}
\title{Square root of a matrix}
\usage{
Eigen_sqrt(M)
}
\arguments{
\item{M}{a square matrix, real or complex}
}
\value{
A square root of \code{M}.
}
\description{
Square root of a real or complex square matrix, when possible.
}
\details{
See \href{https://eigen.tuxfamily.org/dox/unsupported/group__MatrixFunctions__Module.html#title12}{matrix square root}.
}
\examples{
# Rotation matrix over 60 degrees:
M <- cbind(c(cos(pi/3), sin(pi/3)), c(-sin(pi/3), cos(pi/3)))
# Its square root, the rotation matrix over 30 degrees:
Eigen_sqrt(M)
}
