% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_elo.R
\name{extract_elo}
\alias{extract_elo}
\title{extract Elo ratings from elo object}
\usage{
extract_elo(
  eloobject,
  extractdate = eloobject$misc["maxDate"],
  standardize = FALSE,
  IDs = NULL,
  NA.interpolate = FALSE,
  daterange = 1
)
}
\arguments{
\item{eloobject}{result from \code{\link{elo.seq}}}

\item{extractdate}{character, date on which Elo ratings should be obtained, defaults to the last day in the data set}

\item{standardize}{logical, should the returned ratings be scaled between 0 and 1. Default is \code{FALSE}. See \code{\link{scale_elo}}}

\item{IDs}{character, specify IDs for which ratings are returned. By default, returns all that were present on the date or at least on one day of the date range}

\item{NA.interpolate}{if \code{FALSE} (default), the last known rating is returned, which might not be from the specified date itself (but older). If \code{TRUE}, ratings on days without observations are linearly interpolated between days with known ratings (i.e. dates with observed interactions)}

\item{daterange}{if averaged ratings are desired, supply here the number of days from \cr
\code{extractdate - 1}. By default (\code{daterange = 1}), the ratings of the single \code{extractdate} are returned. \code{daterange = 2} produces average ratings from \code{extractdate} and the day after, and so on...}
}
\value{
named (IDs) vector of (average) Elo ratings, or an unnamed vector of ratings (if length of \code{extracte} is larger than 1)
}
\description{
extract Elo ratings from elo object
}
\details{
\code{extractdate} can be also a vector of dates. In this case, the \code{IDs} argument has to be either a vector of length 1 (i.e. a single individual) or a vector of the same length as \code{extractdate}. In the first case, the ratings for the same individual are returned on the dates specified in \code{extractdate}. In the second case, dates and IDs are matched, i.e. the rating of the individual on that date is returned in the same order as the dates/IDs vectors.
}
\examples{
data(adv)
SEQ <- elo.seq(winner=adv$winner, loser=adv$loser, Date=adv$Date)
extract_elo(SEQ, "2010-01-30")
extract_elo(SEQ, "2010-01-30", standardize=TRUE)

# same ratings (regardless of NA.interpolate),
# since "g" was observed on both days
extract_elo(SEQ, "2010-01-29", IDs="g")
extract_elo(SEQ, "2010-01-29", IDs="g", NA.interpolate=TRUE)

extract_elo(SEQ, "2010-01-31", IDs="g")
extract_elo(SEQ, "2010-01-31", IDs="g", NA.interpolate=TRUE)

# different ratings (depending on NA.interpolate),
# since "g" was not observed that day
extract_elo(SEQ, "2010-01-30", IDs="g")
extract_elo(SEQ, "2010-01-30", IDs="g", NA.interpolate=TRUE)

extract_elo(SEQ, "2010-01-10", daterange=5)
extract_elo(SEQ, "2010-01-10", daterange=5, NA.interpolate=TRUE)

# and for multiple dates and a single IDs
dates <- sample(adv$Date, size = 10, replace = TRUE)
ids <- "b"
extract_elo(eloobject = SEQ, extractdate = dates, standardize = FALSE, IDs = ids)

# and for multiple dates and IDs
dates <- sample(adv$Date, size = 10, replace = TRUE)
ids <- sample(colnames(advpres)[2:8], size = 10, replace = TRUE)
extract_elo(eloobject = SEQ, extractdate = dates, standardize = FALSE, IDs = ids)

}
\author{
Christof Neumann
}
