% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simple_dom.R
\name{simple_dom}
\alias{simple_dom}
\title{simple dominance indices}
\usage{
simple_dom(winner, loser, Date = NULL, daterange = NULL)
}
\arguments{
\item{winner}{character or factor with winner}

\item{loser}{character or factor with winner}

\item{Date}{not yet implemented}

\item{daterange}{not yet implemented}
}
\value{
a data.frame with one row per individual and several 'simple' dominance indices
}
\description{
simple dominance indices
}
\details{
The indices that are calculated are the following
\describe{
  \item{\code{winprop}}{the proportion of all interactions won}
  \item{\code{domover}}{the proportion of individuals dominated (regardless of whether any interactions may have occured, i.e. the number of individuals dominated is divided by N - 1 for all individuals)}
  \item{\code{domover_rel}}{the proportion of individuals dominated with which the focal interacted}
}
}
\examples{
xdata <- randomsequence(nID = 10, avgIA = 20, reversals = 0.2)$seqdat
simple_dom(xdata$winner, xdata$loser)
}
