% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_steepness.R
\name{plot_steepness}
\alias{plot_steepness}
\title{plot steepness density}
\usage{
plot_steepness(x, adjustpar = 1.5, print_numbers = TRUE)
}
\arguments{
\item{x}{result from \code{\link{elo_steepness_from_matrix}},
\code{\link{elo_steepness_from_sequence}} or
\code{\link{davids_steepness}}}

\item{adjustpar}{numeric, parameter for smoothing posterior of individual
scores}

\item{print_numbers}{logical, if \code{TRUE} (default) print numeric
summaries into into the plot and omit them if \code{FALSE}}
}
\value{
a plot
}
\description{
plot steepness density
}
\examples{
\donttest{
data("dommats", package = "EloRating")
m <- dommats$elephants
res <- elo_steepness_from_matrix(m, n_rand = 3, refresh = 0, cores = 2, 
                                 iter = 1000, warmup = 500)
plot_steepness(res)
}
}
