% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scores.R
\name{scores}
\alias{scores}
\title{numeric summaries of individual Elo-ratings or David's scores}
\usage{
scores(x, quantiles = c(0.045, 0.955))
}
\arguments{
\item{x}{result from \code{\link{elo_steepness_from_matrix}} or
\code{\link{davids_steepness}}}

\item{quantiles}{numeric, the quantiles to be returned}
}
\value{
a data.frame with one line per individual, providing
summaries of posteriors for individual scores
}
\description{
numeric summaries of individual Elo-ratings or David's scores
}
\examples{
\donttest{
data("bonobos", package = "EloRating")
res <- davids_steepness(bonobos, refresh = 0, cores = 2)
scores(res)

data("dommats", package = "EloRating")
m <- dommats$elephants
res <- elo_steepness_from_matrix(m, n_rand = 1, refresh = 0, cores = 2)
scores(res)
}
}
