% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/EpiBayes_s.R
\name{EpiBayes_s}
\alias{EpiBayes_s}
\title{Disease Model with Storage}
\usage{
EpiBayes_s(H, k, n, seasons, reps, MCMCreps, poi = "tau", y = NULL,
  mumodes = matrix(c(0.5, 0.7, 0.5, 0.7, 0.02, 0.5, 0.02, 0.5), 4, 2, byrow =
  TRUE), pi.thresh = 0.02, tau.thresh = 0.05, gam.thresh = 0.1,
  tau.T = 0, poi.lb = 0, poi.ub = 1, p1 = 0.95, psi = 4,
  omegaparm = c(100, 1), gamparm = c(100, 1), tauparm = c(1, 1),
  etaparm = c(100, 6), thetaparm = c(100, 6), burnin = 1000)
}
\arguments{
\item{H}{Number of subzones/states. Should be a 1 if there are only one or two levels
of sampling. Integer scalar.}

\item{k}{Number of clusters / farms / ponds / herds. Should be a 1 if there is only one
level of sampling. Integer vector (\code{H} x 1).}

\item{n}{Number of subjects / animals / mussels / pigs per cluster (can differ among
clusters). Integer vector (\code{sum(k)} x 1).}

\item{seasons}{Numeric season for  each cluster in the order: Summer (1),  Fall (2),
Winter (3),  Spring (4). Integer vector (\code{sum(k)} x 1).}

\item{reps}{Number of (simulated) replicated data sets. Integer scalar.}

\item{MCMCreps}{Number of iterations in the MCMC chain per replicated data set.
Integer scalar.}

\item{poi}{The p(arameter) o(f) i(nterest) specifies one of the subzone-level prevalence
(\code{gam}) or the cluster-level prevalence (\code{tau}), indicating which variable
with which to compute the simulation output \code{p2.tilde}, \code{p4.tilde}, and
\code{p6.tilde}. Character scalar.}

\item{y}{An optional input of sums of positive diagnostic testing results if one has a
specific set of diagnostic testing outcomes for  every subject (will simulate these
if  this is left as \code{NULL}). Integer matrix (\code{reps} x \code{sum(k)}).}

\item{mumodes}{Modes and (a) 95th percentiles for  mode \eqn{\leq}  0.50 or (b) 5th
percentiles for  mode \eqn{>} 0.5 for  season-specific mean prevalences for
diseased clusters in the order: Summer,  Fall,  Winter,  Spring.
Real matrix (4 x 2).}

\item{pi.thresh}{Threshold that we must show subject-level prevalence is below to
declare disease freedom. Real scalar.}

\item{tau.thresh}{Threshold that we must show cluster-level prevalence is below to
declare disease freedom. Real scalar.}

\item{gam.thresh}{Threshold that we must show subzone-level prevalence is below to
declare disease freedom. Real scalar.}

\item{tau.T}{Assumed true cluster-level prevalence (used to simulate data to feed
into the Bayesian model). Real scalar.}

\item{poi.lb,poi.ub}{Lower and upper bounds for posterior \code{poi} prevalences
to show ability to capture \code{poi} with certain probability. Real scalars.}

\item{p1}{Probability we must show \code{poi} prevalence is below / above the thresholds
\code{pi.thresh} or \code{tau.thresh} or within specified bounds. Real scalar.}

\item{psi}{(Inversely related to) the variability of the subject-level prevalences
in diseased clusters. Real scalar.}

\item{omegaparm}{Prior parameters for the beta-distributed input \code{omega}, which
is the probability that the disease is in the region. Real vector (2 x 1).}

\item{gamparm}{Prior parameters for the beta-distributed input \code{gam}, which
is the subzone-level prevalence (or the prevalence among subzones). Real
vector (2 x 1).}

\item{tauparm}{Prior parameters for the beta-distributed input \code{tau}, which is the
cluster-level prevalence (or the prevalence among clusters). Real vector (2 x 1).}

\item{etaparm}{Prior parameters for the beta-distributed input \code{eta}, which is the
sensitivity of the diagnostic test. Real vector (2 x 1).}

\item{thetaparm}{Prior parameters for the beta-distributed input \code{theta}, which is
the specificity of the diagnostic test. Real vector (2 x 1).}

\item{burnin}{Number of MCMC iterations to discard from the beginning of the chain.
    Integer scalar.}
}
\value{
This function is the 'storage' model meaning it returns the posterior distributions of
    all of the model parameters. It returns enough to perform inference \emph{and}
    to perform diagnostic testing for the model fit nor MCMC convergence.
    If this is the first time running the model, we recommend that the user utilizes
    this function, \code{\link{EpiBayes_s}}, and diagnose issues before continuing with
    the 'no storage' model, \code{\link{EpiBayes_ns}}, for faster results, especially if
    it is being used as a simulation-type model and not a poserior inference-type model.
    Nevertheless, below are the outputs of this model.

\tabular{lll}{
    Output \tab Attributes \tab Description \cr
    \code{p2.tilde} \tab Real scalar \tab Proportion of simulated data sets that result in the probability of \code{poi} prevalence \emph{below} \code{poi.thresh} with probability \code{p1} \cr
    \code{p4.tilde} \tab Real scalar \tab Proportion of simulated data sets that result in the probability of \code{poi} prevalence \emph{above} \code{poi.thresh} with probability \code{p1} \cr
    \code{p6.tilde} \tab Real scalar \tab Proportion of simulated data sets that result in the probability of \code{poi} prevalence \emph{between} \code{poi.lb} and \code{poi.ub} with probability \code{p1} \cr
    \code{taumat} \tab Real array (\code{reps} x \code{H} x \code{MCMCreps}) \tab Posterior distributions of the cluster-level prevalence for all simulated data sets (i.e., \code{reps}) \cr
    \code{gammat} \tab  Real matrix (\code{reps} x \code{MCMCreps}) \tab Posterior distribution of the subzone-level prevalence \cr
    \code{omegamat} \tab  Real matrix (\code{reps} x \code{MCMCreps}) \tab Posterior distribution of the probability of the disease being in the region \cr
    \code{z.gammat} \tab  Real matrix (\code{reps} x \code{MCMCreps}) \tab Posterior distribution for the latent indicator denoting whether the disease is present among the subzones \cr
    \code{z.taumat} \tab Real array (\code{reps} x \code{H} x \code{MCMCreps}) \tab Posterior distribution for the latent indicator denoting whether the disease is present among the clusters \cr
	   \code{pimat} \tab Real array (\code{reps} x \code{sum(k)} x \code{MCMCreps}) \tab Posterior distribution for the subject-level (or within-cluster) prevalence \cr
    \code{z.pimat} \tab Real array (\code{reps} x \code{sum(k)} x \code{MCMCreps}) \tab Posterior distribution for the latent indicators denoting whether the disease is present within any given cluster \cr
    \code{mumat} \tab Real matrix (\code{reps} x 4 x \code{MCMCreps}) \tab Posterior distribution for the mean prevalence within diseased clusters \cr
    \code{psi} \tab Real scalar \tab User-input \code{psi} value \cr
    \code{etamat} \tab Real matrix (\code{reps} x \code{MCMCreps}) \tab Posterior distribution for the sensitivity of the diagnostic test \cr
    \code{thetamat} \tab Real matrix (\code{reps} x \code{MCMCreps}) \tab Posterior distribution for the specificity of the diagnostic test \cr
    \code{c1mat} \tab Real array (\code{reps} x \code{sum(k)} x \code{MCMCreps}) \tab Posterior disribution for the latent indicators denoting true positive results from the diagnostic test \cr
    \code{c2mat} \tab Real array (\code{reps} x \code{sum(k)} x \code{MCMCreps}) \tab Posterior disribution for the latent indicators denoting true negative results from the diagnostic test \cr
    \code{mumh.tracker} \tab Real matrix (\code{reps} x 4) \tab Vector of proportions of accepted Metropolis-Hastings proposals for the simulation from the posterior of input \code{mu} \cr
    \code{y} \tab Integer matrix (\code{reps} x \code{sum(k)}) \tab Matrix of observed counts of diseased subjects per cluster per simulated data set (or the actual observed counts input by the user) \cr
    \code{ForOthers} \tab \tab Various other data not intended to be used by the user, but used to pass information on to the \code{plot}, \code{summary}, and \code{print} methods \cr
}

    The posterior distribution output, say \code{taumat}, can be manipulated after it is
    returned with the \pkg{coda} package after it is converted to an \code{mcmc} object.
}
\description{
This function is used to model disease (freedom and prevalence estimation) using
    a Bayesian hierarchical model one, two, or three levels of sampling.
    The most general, the three level, would be represented by the hierarchy:
    (region -> subzone -> cluster -> subject) and the two- and one- level sampling would
    simply be the same with either subzone removed or subzone \emph{and} cluster
    removed, respectively. This function is the 'storage' model and hence stores all,
    even extraneous, output.
}
\details{
Note that this function performs in the same manner as \code{\link{EpiBayes_ns}} except
    it stores the posterior distributions of all of the parameters in the model and
    hence takes a bit longer to run.
    This model is a Bayesian hierarchical model that serves two main purposes:
    \itemize{
        \item Simulation model: can simulate data under user-specified conditions
        and run replicated data sets under the Bayesian model to observed the behavior
        of the system under random realizations of simulated data.
        \item Posterior inference model: can use actual observed data from the field,
        run it through the Bayesian model,  and make inference on parameter(s) of
        interest using the posterior distribution(s).
    }

    The posterior distributions are avaialable for a particular parameter, say
    \code{tau}, by typing \code{name_of_your_model$taumat}.
    Note: be careful about the size of the \code{taumat} matrix you are calling. The
    last index of any of the variables from above is the MCMC replications and so we
    would typically always omit the last index when looking at any particular variable.
    \itemize{
        \item If  we want to look at the posterior distribution of the cluster level
        prevalence (\code{tau}) for  the first replication,  we will note that taumat is
        a matrix with rows indexed by replication and columns by MCMC replications. Then,
        we will type something like \code{name_of_your_model$taumat[1, ]} to visually
        inspect the posterior distribution in the form of a vector. For the second
        replication, we can type \code{name_of_your_model$taumat[2, ]},  and so forth.
        Then,  we can make histograms of these distributions if we so desire by the
        following code:
        \code{hist(name_of_your_model$taumat[1, ], col = "cyan");box("plot")}.
        To observe a trace plot,  we can type:
        \code{plot(name_of_your_model$taumat[1, ], type = "l")}
        for  all of the MCMC replications and we can look
        at the trace plot after a burnin of 1000 iterations by typing:
        \code{plot(name_of_your_model$taumat[1, -c(1:1000)], type ="l")}.

        \item If  we want to look at the posterior distribution for the subject-level
        prevalence (\code{pi}) for  the tenth replication in the third cluster, we would
        type \code{name_of_your_model$pimat[10, 1, ]} since the matrix containing the
        posterior distributions for  the subject-level prevalences are indexed by
        replications in the first dimension, clusters in the second, and MCMC
        replications in the third. We can make histograms and trace plots using the same
        code as from above.
    }
}
\section{Parameter Meanings}{

Below we describe the meanings of the parameters in epidemiological language for ease
    of implementation and elicitation of inputs to this function.

\tabular{lll}{
    Parameter \tab (3-level) Description \tab (2-level) Description \cr
		 \code{omega} \tab Probability of disease being in the region. \tab Not used. \cr
      \code{gam} \tab Subzone-level (between-subzone) prevalence. \tab Probability of disease being in the region. \cr
      \code{z.gam} \tab Subzone-level (between-subzone) prevalence latent indicator variable. \tab Not used. \cr
		 \code{tau} \tab Cluster-level (between-cluster) prevalence. \tab Same as (3-level). \cr
		 \code{z.tau} \tab Cluster-level (between-cluster) prevalence latent indicator variable. \tab Same as (3-level). \cr
		 \code{pi} \tab Subject-level (within-cluster) prevalence. \tab Same as (3-level). \cr
		 \code{z.pi} \tab Subject-level (within-cluster) prevalence latent indicator variable. \tab Same as (3-level). \cr
		 \code{mu} \tab Mean prevalence among infected clusters. \tab Same as (3-level). \cr
		 \code{psi} \tab (Related to) variability of prevalence among infected clusters (inversely related so higher \code{psi} -> lower variance of prevalences among diseased clusters). \tab Same as (3-level). \cr
		 \code{eta} \tab Diagnostic test sensitivity. \tab Same as (3-level). \cr
		 \code{theta} \tab Diagnostic test specificity. \tab Same as (3-level). \cr
		 \code{c1} \tab Latent count of true positive diagnostic test results. \tab Same as (3-level). \cr
		 \code{c2} \tab Latent count of true negative diagnostic test results. \tab Same as (3-level). \cr
}

    Note that in the code, each of these variables are denoted, for example,
    \code{taumat} instead of plain \code{tau} to denote that that variable is a
    matrix (or, more generally an array) of values.
}
\examples{
testrun_storage = EpiBayes_s(
		H = 2,
		k = rep(30, 2),
		n = rep(rep(150, 30), 2),
		seasons = rep(c(1, 2, 3, 4), each = 15),
		reps = 10,
		MCMCreps = 10,
		poi = "tau",
		y = NULL,
		mumodes = matrix(c(
			0.50, 0.70,
			0.50, 0.70,
			0.02, 0.50,
			0.02, 0.50
			), 4, 2, byrow = TRUE
		),
		pi.thresh = 0.05,
	    tau.thresh = 0.02,
     gam.thresh = 0.10,
		tau.T = 0,
		poi.lb = 0,
		poi.ub = 1,
		p1 = 0.95,
		psi = 4,
		omegaparm = c(100, 1),
		gamparm = c(100, 1),
		tauparm = c(1, 1),
		etaparm = c(100, 6),
		thetaparm = c(100, 6),
		burnin = 1
		)

testrun_storage
print(testrun_storage)
testrun_storagesummary = summary(testrun_storage, prob = 0.90, n.output = 5)
testrun_storagesummary
plot(testrun_storage$taumat[1, 1, ], type = "l")
plot(testrun_storage$gammat[1, ], type = "l")

## Can look at all posterior distributions
    plot(testrun_storage$pimat[1, 1, ], type = "l")
    plot(testrun_storage$omegamat[1, ], type = "l")
}
\references{
Branscum, A., Johnson, W., and Gardner, I. (2006) Sample size calculations for disease
    freedom and prevalence estimation surveys. \emph{Statistics in Medicine 25},
    2658-2674.
}
\seealso{
The function \code{\link{EpiBayes_ns}} stores less output so the user may run the model
    more quickly, while losing the ability to diagnose any model fit or convergence
    issues.
}

