% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deprecated.R
\name{lognorm_dist_def}
\alias{lognorm_dist_def}
\title{Generate a Log Normal Distribution Definition Based on Parameter Estimates}
\usage{
lognorm_dist_def(mean, mean_sd, sd, sd_sd, max_value, samples, to_log = FALSE)
}
\arguments{
\item{mean}{Numeric, log mean parameter of the gamma distribution.}

\item{mean_sd}{Numeric, standard deviation of the log mean parameter.}

\item{sd}{Numeric, log sd parameter of the gamma distribution.}

\item{sd_sd}{Numeric, standard deviation of the log sd parameter.}

\item{max_value}{Numeric, the maximum value to allow. Defaults to 120.
Samples outside of this range are resampled.}

\item{samples}{Numeric, number of sample distributions to generate.}

\item{to_log}{Logical, should parameters be logged before use.}
}
\value{
A \verb{<data.table>} defining the distribution as used by \code{\link[=dist_skel]{dist_skel()}}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}
Generates a distribution definition when only parameter estimates
are available for log normal distributed parameters. See \code{\link[=rlnorm]{rlnorm()}} for
distribution information.
}
\examples{
def <- lognorm_dist_def(
  mean = 1.621, mean_sd = 0.0640,
  sd = 0.418, sd_sd = 0.0691,
  max_value = 20, samples = 10
)
print(def)
def$params[[1]]

def <- lognorm_dist_def(
  mean = 5, mean_sd = 1,
  sd = 3, sd_sd = 1,
  max_value = 20, samples = 10,
  to_log = TRUE
)
print(def)
def$params[[1]]
}
\keyword{internal}
