% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opts.R
\name{generation_time_opts}
\alias{generation_time_opts}
\title{Generation Time Distribution Options}
\usage{
generation_time_opts(
  dist = Fixed(1),
  ...,
  disease,
  source,
  max = 14,
  fixed = FALSE,
  tolerance = 0.001,
  weight_prior = TRUE
)
}
\arguments{
\item{dist}{A delay distribution or series of delay distributions . If no
distribution is given a fixed generation time of 1 will be assumed.}

\item{...}{deprecated; use \code{dist} instead}

\item{disease}{deprecated; use \code{dist} instead}

\item{source}{deprecated; use \code{dist} instead}

\item{max}{deprecated; use \code{dist} instead}

\item{fixed}{deprecated; use \code{dist} instead}

\item{tolerance}{Numeric; the desired tolerance level.}

\item{weight_prior}{Logical; if TRUE (default), any priors given in \code{dist}
will be weighted by the number of observation data points, in doing so
approximately placing an independent prior at each time step and usually
preventing the posteriors from shifting. If FALSE, no weight will be
applied, i.e. any parameters in \code{dist} will be treated as a single
parameters.}
}
\value{
A \verb{<generation_time_opts>} object summarising the input delay
distributions.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}
Returns generation time parameters in a format for lower level model use.
}
\examples{
# default settings with a fixed generation time of 1
generation_time_opts()

# A fixed gamma distributed generation time
generation_time_opts(Gamma(mean = 3, sd = 2, max = 14))

# An uncertain gamma distributed generation time
generation_time_opts(
  Gamma(
    mean = Normal(mean = 3, sd = 1),
    sd = Normal(mean = 2, sd = 0.5),
    max = 14
  )
)

# An example generation time
generation_time_opts(example_generation_time)
}
\seealso{
\code{\link[=convert_to_logmean]{convert_to_logmean()}} \code{\link[=convert_to_logsd]{convert_to_logsd()}}
\code{\link[=bootstrapped_dist_fit]{bootstrapped_dist_fit()}} \code{\link[=Gamma]{Gamma()}} \code{\link[=LogNormal]{LogNormal()}} \code{\link[=Fixed]{Fixed()}}
}
