% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dist_spec.R
\name{extract_single_dist}
\alias{extract_single_dist}
\title{Extract a single element of a composite \verb{<dist_spec>}}
\usage{
extract_single_dist(x, i)
}
\arguments{
\item{x}{A composite \code{dist_spec} object}

\item{i}{The index to extract}
}
\value{
A single \code{dist_spec} object
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
}
\examples{
dist1 <- LogNormal(mean = 1.6, sd = 0.5, max = 20)

# An uncertain gamma distribution with mean 3 and sd 2
dist2 <- Gamma(
  mean = Normal(3, 0.5), sd = Normal(2, 0.5), max = 20
)

# Multiple distributions
\dontrun{
  dist <- dist1 + dist2
  extract_single_dist(dist, 2)
}
}
\keyword{internal}
