% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dist_spec.R
\name{get_pmf}
\alias{get_pmf}
\title{Get the probability mass function of a nonparametric distribution}
\usage{
get_pmf(x, id = NULL)
}
\arguments{
\item{x}{A \verb{<dist_spec>}.}

\item{id}{Integer; the id of the distribution to use (if x is a composite
distribution). If \code{x} is a single distribution this is ignored and can be
left at its default value of \code{NULL}.}
}
\value{
The pmf of the distribution
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
}
\examples{
dist <- discretise(Gamma(shape = 3, rate = 2, max = 10))
get_pmf(dist)
}
