% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checks.R
\name{check_na_setting_against_data}
\alias{check_na_setting_against_data}
\title{Cross-check treatment of \code{NA} in obs_opts() against input data}
\usage{
check_na_setting_against_data(data, cols_to_check, obs)
}
\arguments{
\item{data}{The raw data}

\item{cols_to_check}{A character vector of the columns to check}

\item{obs}{A call to \code{\link[=obs_opts]{obs_opts()}}}
}
\value{
\code{\link[=obs_opts]{obs_opts()}}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

This function checks the input data for implicit and/or explicit missingness
and checks if the user specified \code{na = "missing"} in \code{\link[=obs_opts]{obs_opts()}}.
If the two are TRUE, it throws a message about how the model treats
missingness and provides alternatives. It returns an unmodified \code{\link[=obs_opts]{obs_opts()}}.

This function is necessary because the data and observation model
do not currently interact internally. It will be deprecated in future
versions when the data specification interface is enhanced.
}
\keyword{internal}
