% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Simulation.R
\name{createSimulationSettings}
\alias{createSimulationSettings}
\title{Create simulation settings}
\usage{
createSimulationSettings(
  nSites = 5,
  n = 10000,
  treatedFraction = 0.2,
  nStrata = 10,
  minBackgroundHazard = 2e-07,
  maxBackgroundHazard = 2e-05,
  hazardRatio = 2,
  randomEffectSd = 0
)
}
\arguments{
\item{nSites}{Number of database sites to simulate.}

\item{n}{Number of subjects per site. Either a single number, or a vector of
length nSites.}

\item{treatedFraction}{Fraction of subjects that is treated. Either a single number, or a
vector of length nSites.}

\item{nStrata}{Number of strata per site. Either a single number, or a vector of
length nSites.}

\item{minBackgroundHazard}{Minimum background hazard. Either a single number, or a vector of
length nSites.}

\item{maxBackgroundHazard}{Maximum background hazard. Either a single number, or a vector of
length nSites.}

\item{hazardRatio}{Hazard ratio.}

\item{randomEffectSd}{Standard deviation of the log(hazardRatio). Fixed effect if equal to 0.}
}
\value{
An object of type \code{simulationSettings}, to be used in the \code{\link[=simulatePopulations]{simulatePopulations()}} function.
}
\description{
Create an object specifying a simulation. Currently only Cox proportional hazard models are
supported.
}
\examples{
settings <- createSimulationSettings(nSites = 1, hazardRatio = 2)
populations <- simulatePopulations(settings)

# Fit a Cox regression for the simulated data site:
cyclopsData <- Cyclops::createCyclopsData(Surv(time, y) ~ x + strata(stratumId),
                                          data = populations[[1]],
                                          modelType = "cox")
cyclopsFit <- Cyclops::fitCyclopsModel(cyclopsData)
coef(cyclopsFit)

# (Estimates in this example will vary due to the random simulation)

}
\seealso{
\link{simulatePopulations}
}
