/*
 * Decompiled with CFR 0.152.
 */
package org.ohdsi.metaAnalysis;

import dr.inference.distribution.DistributionLikelihood;
import dr.inference.loggers.Loggable;
import dr.inference.model.CompoundLikelihood;
import dr.inference.model.Likelihood;
import dr.inference.model.Parameter;
import dr.inference.operators.AdaptationMode;
import dr.inference.operators.MCMCOperator;
import dr.inference.operators.OperatorSchedule;
import dr.inference.operators.RandomWalkOperator;
import dr.inference.operators.SimpleOperatorSchedule;
import dr.math.distributions.Distribution;
import dr.math.distributions.NormalDistribution;
import dr.util.Attribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.ohdsi.data.CoxData;
import org.ohdsi.data.SortedCoxData;
import org.ohdsi.likelihood.CoxPartialLikelihood;
import org.ohdsi.mcmc.Analysis;
import org.ohdsi.mcmc.Runner;

public class JointAnalysis
implements Analysis {
    private final Likelihood likelihood;
    private final Likelihood prior;
    private final Likelihood joint;
    private final OperatorSchedule schedule;
    private final Parameter beta = new Parameter.Default("beta", 0.0, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);

    public JointAnalysis(CoxData coxData, double d) {
        this(coxData.getSortedData(), d);
    }

    public JointAnalysis(SortedCoxData sortedCoxData, double d) {
        this.likelihood = new CoxPartialLikelihood(this.beta, sortedCoxData);
        DistributionLikelihood distributionLikelihood = new DistributionLikelihood((Distribution)new NormalDistribution(0.0, d));
        distributionLikelihood.addData((Attribute)this.beta);
        this.prior = distributionLikelihood;
        this.joint = new CompoundLikelihood(Arrays.asList(this.likelihood, this.prior));
        this.schedule = new SimpleOperatorSchedule(1000, 0.0);
        double d2 = 1.0;
        AdaptationMode adaptationMode = AdaptationMode.ADAPTATION_ON;
        RandomWalkOperator.BoundaryCondition boundaryCondition = RandomWalkOperator.BoundaryCondition.reflecting;
        this.schedule.addOperator((MCMCOperator)new RandomWalkOperator(this.beta, null, 0.75, boundaryCondition, d2, adaptationMode));
    }

    @Override
    public List<Loggable> getLoggerColumns() {
        this.likelihood.setId("likelihood");
        this.prior.setId("prior");
        ArrayList<Loggable> arrayList = new ArrayList<Loggable>();
        arrayList.add((Loggable)this.likelihood);
        arrayList.add((Loggable)this.prior);
        arrayList.add((Loggable)this.beta);
        return arrayList;
    }

    @Override
    public Likelihood getJoint() {
        return this.joint;
    }

    @Override
    public OperatorSchedule getSchedule() {
        return this.schedule;
    }

    private static SortedCoxData parseDataFile(String string) {
        return null;
    }

    public static void main(String[] stringArray) {
        int n = 1100000;
        int n2 = 100000;
        int n3 = 1000;
        int[] nArray = new int[]{1, 1, 0, 1, 1, 0, 1};
        double[] dArray = new double[]{4.0, 3.0, 3.0, 2.0, 2.0, 1.0, 1.0};
        double[] dArray2 = new double[]{0.0, 2.0, 0.0, 0.0, 1.0, 1.0, 1.0};
        int[] nArray2 = new int[]{0, 0, 1, 1, 1, 0, 0};
        CoxData coxData = new CoxData(nArray2, nArray, dArray, dArray2);
        JointAnalysis jointAnalysis = new JointAnalysis(coxData, 1000.0);
        Runner runner = new Runner(jointAnalysis, n, n2, n3, 666.0);
        runner.run();
        runner.processSamples();
    }
}

