/*
 * Decompiled with CFR 0.152.
 */
package org.ohdsi.simpleDesign;

import dr.inference.distribution.DistributionLikelihood;
import dr.inference.distribution.NormalDistributionModel;
import dr.inference.distribution.ParametricDistributionModel;
import dr.inference.loggers.Loggable;
import dr.inference.model.CompoundLikelihood;
import dr.inference.model.CompoundParameter;
import dr.inference.model.Likelihood;
import dr.inference.model.Parameter;
import dr.inference.operators.AdaptationMode;
import dr.inference.operators.MCMCOperator;
import dr.inference.operators.OperatorSchedule;
import dr.inference.operators.RandomWalkOperator;
import dr.inference.operators.SimpleOperatorSchedule;
import dr.math.distributions.Distribution;
import dr.math.distributions.GammaDistribution;
import dr.math.distributions.NormalDistribution;
import dr.util.Attribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.ohdsi.likelihood.EmpiricalModelLikelihood;
import org.ohdsi.mcmc.Analysis;
import org.ohdsi.mcmc.Runner;
import org.ohdsi.metaAnalysis.EmpiricalDataModel;
import org.ohdsi.metaAnalysis.ExtendingEmpiricalDataModel;

public class ProfileHierarchicalNormalAnalysis
implements Analysis {
    private final Likelihood likelihood;
    private final Likelihood prior;
    private final Likelihood joint;
    private final Parameter beta;
    private final Parameter mean;
    private final Parameter precision;
    private final OperatorSchedule schedule;

    public ProfileHierarchicalNormalAnalysis(List<EmpiricalDataModel> list, double d, double d2, double d3) {
        Parameter parameter;
        EmpiricalDataModel empiricalDataModel2;
        ArrayList<EmpiricalModelLikelihood> arrayList = new ArrayList<EmpiricalModelLikelihood>();
        this.beta = new CompoundParameter("beta");
        for (EmpiricalDataModel empiricalDataModel2 : list) {
            arrayList.add(new EmpiricalModelLikelihood("likelihood", empiricalDataModel2));
            parameter = empiricalDataModel2.getCompoundParameter();
            if (parameter.getDimension() != 1) {
                throw new RuntimeException("Not yet implemented");
            }
            parameter.setParameterValue(0, d3);
            ((CompoundParameter)this.beta).addParameter(parameter);
        }
        this.likelihood = new CompoundLikelihood(arrayList);
        this.mean = new Parameter.Default("mean", 1);
        this.mean.setParameterValue(0, 0.0);
        this.precision = new Parameter.Default("precision", 1);
        this.precision.setParameterValue(0, 1.0);
        DistributionLikelihood distributionLikelihood = new DistributionLikelihood((ParametricDistributionModel)new NormalDistributionModel(this.mean, this.precision, true));
        distributionLikelihood.addData((Attribute)this.beta);
        empiricalDataModel2 = new DistributionLikelihood((Distribution)new NormalDistribution(d, d2));
        empiricalDataModel2.addData((Attribute)this.mean);
        parameter = new DistributionLikelihood((Distribution)new GammaDistribution(d, d2));
        parameter.addData((Attribute)this.precision);
        this.prior = new CompoundLikelihood(Arrays.asList(distributionLikelihood, empiricalDataModel2, parameter));
        this.prior.setId("prior");
        this.joint = new CompoundLikelihood(Arrays.asList(this.likelihood, this.prior));
        this.joint.setId("joint");
        this.schedule = new SimpleOperatorSchedule(1000, 0.0);
        double d4 = 1.0;
        AdaptationMode adaptationMode = AdaptationMode.ADAPTATION_ON;
        RandomWalkOperator.BoundaryCondition boundaryCondition = RandomWalkOperator.BoundaryCondition.reflecting;
        for (EmpiricalDataModel empiricalDataModel3 : list) {
            for (Parameter parameter2 : empiricalDataModel3.getIndividualParameters()) {
                this.schedule.addOperator((MCMCOperator)new RandomWalkOperator(parameter2, null, 0.75, boundaryCondition, d4, adaptationMode));
            }
        }
    }

    @Override
    public List<Loggable> getLoggerColumns() {
        ArrayList<Loggable> arrayList = new ArrayList<Loggable>();
        arrayList.add((Loggable)this.likelihood);
        arrayList.add((Loggable)this.prior);
        arrayList.add((Loggable)this.beta);
        return arrayList;
    }

    @Override
    public Likelihood getJoint() {
        return this.joint;
    }

    @Override
    public OperatorSchedule getSchedule() {
        return this.schedule;
    }

    public static void main(String[] stringArray) {
        int n = 1100000;
        int n2 = 100000;
        int n3 = 1000;
        ExtendingEmpiricalDataModel extendingEmpiricalDataModel = new ExtendingEmpiricalDataModel("profile.txt");
        ProfileHierarchicalNormalAnalysis profileHierarchicalNormalAnalysis = new ProfileHierarchicalNormalAnalysis(Collections.singletonList(extendingEmpiricalDataModel), 0.0, 10.0, 0.0);
        Runner runner = new Runner(profileHierarchicalNormalAnalysis, n, n2, n3, 666.0);
        runner.run();
        runner.processSamples();
    }
}

