% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FixedEffectMetaAnalysis.R
\name{computeFixedEffectMetaAnalysis}
\alias{computeFixedEffectMetaAnalysis}
\title{Compute a fixed-effect meta-analysis}
\usage{
computeFixedEffectMetaAnalysis(data, alpha = 0.05)
}
\arguments{
\item{data}{A data frame containing either normal, skew-normal, custom parametric, or grid
likelihood data. One row per database.}

\item{alpha}{The alpha (expected type I error) used for the confidence intervals.}
}
\value{
The meta-analytic estimate, expressed as the point estimate hazard ratio (rr), its 95 percent
confidence interval (lb, ub), as well as the log of the point estimate (logRr), and the standard
error (seLogRr).
}
\description{
Compute a fixed-effect meta-analysis using a choice of various likelihood approximations.
}
\examples{
# Simulate some data for this example:
populations <- simulatePopulations()

# Fit a Cox regression at each data site, and approximate likelihood function:
fitModelInDatabase <- function(population) {
  cyclopsData <- Cyclops::createCyclopsData(Surv(time, y) ~ x + strata(stratumId),
    data = population,
    modelType = "cox"
  )
  cyclopsFit <- Cyclops::fitCyclopsModel(cyclopsData)
  approximation <- approximateLikelihood(cyclopsFit, parameter = "x", approximation = "custom")
  return(approximation)
}
approximations <- lapply(populations, fitModelInDatabase)
approximations <- do.call("rbind", approximations)

# At study coordinating center, perform meta-analysis using per-site approximations:
computeFixedEffectMetaAnalysis(approximations)

# (Estimates in this example will vary due to the random simulation)

}
\seealso{
\link{approximateLikelihood}, \link{computeBayesianMetaAnalysis}
}
