% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create.pgrid.R
\name{create.pgrid}
\alias{create.pgrid}
\title{Create grid of locations.}
\usage{
create.pgrid(
  xmin,
  xmax,
  ymin,
  ymax,
  nx,
  ny,
  midpoints = FALSE,
  poly.coords = NULL
)
}
\arguments{
\item{xmin}{The minimum value of the boundary of the x coordinates of the spatial domain.}

\item{xmax}{The maximum value of the boundary of the x coordinates of the spatial domain.}

\item{ymin}{The minimum value of the boundary of the y coordinates of the spatial domain.}

\item{ymax}{The maximum value of the boundary of the y coordinates of the spatial domain.}

\item{nx}{The number of gridpoints/cells/pixels in the x direction.}

\item{ny}{The number of gridpoints/cells/pixels in the y direction.}

\item{midpoints}{A logical value (\code{TRUE} or \code{FALSE}) indicating whether the boundary values are for the midpoint of a pixel (\code{midpoints = TRUE}) or for the boundary of the spatial domain in general (\code{midpoints = FALSE}), in which case the midpoints are calculated internally). Default is \code{FALSE}.}

\item{poly.coords}{An \eqn{n \times 2} matrix with the coordinates specifying the polygon vertices of the true spatial domain of interest within the rectangular boundaries provided by \code{xmin}, \code{xmax}, \code{ymin}, and \code{ymax}. If this is provided, the \code{pgrid} returned will be within the convex hull of \code{poly.coords}.}
}
\value{
Returns an object of class \code{pgrid} with the following components: 
\item{pgrid}{An \eqn{n \times 2} matrix of locations (the midpoints of the pixelized grid).}
\item{m}{The number of rows in pgrid.}
\item{p.in.grid}{A vector of 0s and 1s indicating whether the midpoint of each pixel is in the convex hull of \code{poly.coords}. If \code{poly.coords} is not provided, this is a vector of 1s.}
\item{ubx}{The pixel boundaries in the x direction.}
\item{uby}{The pixel boundaries in the y direction.}
\item{upx}{The pixel midpoints in the x direction.}
\item{upy}{The pixel midpoints in the y direction.}
}
\description{
\code{create.pgrid} creates a grid of locations from the boundaries of domain and other information.
}
\details{
The key argument in the function midpoints. If this is \code{TRUE}, it is assumed that the boundaries of the spatial domain correspond to the midpoints of the cell/pixel in the grid. Otherwise, it is assumed that the boundaries correspond to the actual borders of the region of interest. If \code{poly.coords} is supplied, the grid returned is the grid of midpoints contained in the convex hull of \code{poly.coords}.
}
\examples{
pgrida <- create.pgrid(0, 1, 0, 1, nx = 50, ny = 50, midpoints = FALSE)
pgridb <- create.pgrid(.01, .99, .01, .99, nx = 50, ny = 50, midpoints = TRUE)
}
\author{
Joshua French
}
