% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fat2.ad.crd.R
\name{fat2.ad.crd}
\alias{fat2.ad.crd}
\title{Double factorial scheme plus one additional treatment in CRD}
\usage{
fat2.ad.crd(
  factor1,
  factor2,
  repet,
  resp,
  respAd,
  quali = c(TRUE, TRUE),
  mcomp = "tukey",
  fac.names = c("F1", "F2"),
  sigT = 0.05,
  sigF = 0.05
)
}
\arguments{
\item{factor1}{Numeric or complex vector containing the
factor 1 levels.}

\item{factor2}{Numeric or complex vector containing the
factor 2 levels.}

\item{repet}{Numeric or complex vector containing the
replications.}

\item{resp}{Numeric or complex vector containing the
response variable.}

\item{respAd}{Numeric or complex vector containing the
additional treatment.}

\item{quali}{Logic. If TRUE (default), the treatments are
assumed qualitative, if FALSE, quantitatives.}

\item{mcomp}{Allows choosing the multiple comparison test;
the \emph{default} is the test of Tukey, however, the
options are: the LSD test ('lsd'), the LSD test with
Bonferroni protection ('lsdb'), the test of Duncan
('duncan'), the test of Student-Newman-Keuls ('snk'), the
test of Scott-Knott ('sk'), the Calinski and Corsten test
('ccF') and bootstrap multiple comparison's test ('ccboot').}

\item{fac.names}{Allows labeling the factors 1 and 2.}

\item{sigT}{The signficance to be used for the multiple
comparison test; the default is 5\%.}

\item{sigF}{The signficance to be used for the F test of
ANOVA; the default is 5\%.}
}
\value{
The output contains the ANOVA of the referred CRD,
the Shapiro-Wilk normality test for the residuals of the
model, the fitted regression models (when the treatments
are quantitative) and/or the multiple comparison tests
(when the treatments are qualitative).
}
\description{
\code{fat2.ad.crd} Analyses experiments in balanced
Completely Randomized Design in double factorial scheme
with an additional treatment, considering a fixed model.
}
\details{
The arguments sigT and mcomp will be used only when
the treatment are qualitative.
}
\note{
The \code{\link{graphics}} can be used to construct
regression plots and \code{\link{plotres}} for residuals
plots.
}
\examples{
data(ex8)
attach(ex8)
data(secaAd)
fat2.ad.crd(inoculante, biodiesel, vaso, seca, secaAd,
quali = c(TRUE,FALSE), mcomp = "tukey", fac.names =
c("Inoculant", "Biodiesel"), sigT = 0.05, sigF = 0.05)
}
\references{
HEALY, M. J. R. The analysis of a factorial
experiment with additional treatments. Journal of
Agricultural Science, Cambridge, v. 47, p. 205-206. 1956.

FERREIRA, E. B.; CAVALCANTI, P. P.; NOGUEIRA D. A. Funcao
para analisar experimentos em fatorial duplo com um
tratamento adicional, em uma so rodada.In: CONGRESSO DE
POS-GRADUACAO DA UNIVERSIDADE FEDERAL DE LAVRAS, 19., 2010,
Lavras. Resumos... Lavras: UFLA, 2010.
}
\seealso{
\code{\link{fat2.crd}}, \code{\link{fat2.rbd}},
\code{\link{fat3.crd}}, \code{\link{fat3.rbd}},
\code{\link{fat2.ad.crd}}, \code{\link{fat2.ad.rbd}},
\code{\link{fat3.ad.crd}} and \code{\link{fat3.ad.rbd}}.
}
\author{
Eric B Ferreira,
 \email{eric.ferreira@unifal-mg.edu.br}

Denismar Alves Nogueira

Portya Piscitelli Cavalcanti
}
