% Generated by roxygen2 (4.0.2): do not edit by hand
\name{SSRTB}
\alias{SSRTB}
\alias{dSSRTB}
\alias{eSSRTB}
\alias{iSSRTB}
\alias{lSSRTB}
\alias{pSSRTB}
\alias{qSSRTB}
\alias{rSSRTB}
\alias{sSSRTB}
\title{The standard Symmetric-Reflected Truncated Beta (SRTB) Distribution.}
\usage{
dSSRTB(x, shape1 = 2, shape2 = 3, params = list(shape1, shape2))

pSSRTB(q, shape1 = 2, shape2 = 3, params = list(shape1, shape2))

qSSRTB(p, shape1 = 2, shape2 = 3, params = list(shape1, shape2))

rSSRTB(n, shape1 = 2, shape2 = 3, params = list(shape1, shape2))

eSSRTB(X, w, method = "numerical.MLE")

lSSRTB(X, w, shape1 = 2, shape2 = 3, params = list(shape1, shape2),
  logL = TRUE)
}
\arguments{
\item{x,q}{vector of quantiles.}

\item{shape1,shape2}{shape parameters.}

\item{params}{a list includes all parameters}

\item{p}{vector of probabilities.}

\item{n}{number of observations.}

\item{X}{sample observations.}

\item{w}{weights of sample.}

\item{method}{parameter estimation method.}

\item{logL}{logical; if TRUE, lSSRTB gives log likelihood.}

\item{...}{other parameters}
}
\value{
dSSRTB gives the density; pSSRTB gives the distribution function;
qSSRTB gives the quantile function; rSSRTB generates random variables;
eSSRTB estimate the parameters; sSSRTB gives observed scorn function
}
\description{
Density, distribution function, quantile function, random
generation function and parameter estimation function (based on weighted or
unweighted i.i.d. sample) for the SSRTB distribution
}
\details{
Standard Symmetric-Reflected Truncated Beta (SRTB) Distribution

See \href{../doc/Distributions-SSRTB.html}{Distributions-SSRTB}
}
\examples{
\donttest{
# Parameter estimation
n <- 500
shape1 <- 2
shape2 <- 10
X <- rSSRTB(n, shape1, shape2)
(est.par <- eSSRTB(X))

# Histogram and fitted density
den.x <- seq(min(X),max(X),length=100)
den.y <- dSSRTB(den.x,shape1=est.par$shape1,shape2=est.par$shape2)
hist(X, breaks=10, col="red", probability=TRUE, ylim = c(0,1.1*max(den.y)))
lines(den.x, den.y, col="blue", lwd=2)

# Q-Q plot and P-P plot
plot(qSSRTB((1:n-0.5)/n, params=est.par), sort(X), main="Q-Q Plot", xlab="Theoretical Quantiles",
ylab="Sample Quantiles", xlim = c(0,1), ylim = c(0,1))
abline(0,1)

plot((1:n-0.5)/n, pSSRTB(sort(X), params=est.par), main="P-P Plot", xlab="Theoretical Percentile",
ylab="Sample Percentile", xlim = c(0,1), ylim = c(0,1))
abline(0,1)

# A weighted parameter estimation example
n <- 10
par <- list(shape1=1, shape2=2)
X <- rSSRTB(n, params=par)
w <- c(0.13, 0.06, 0.16, 0.07, 0.2, 0.01, 0.06, 0.09, 0.1, 0.12)
eSSRTB(X,w) # estimated parameters of weighted sample
eSSRTB(X) # estimated parameters of unweighted sample

# Alternative parameter estimation methods
(est.par <- eSSRTB(X, method = "numerical.MLE"))

# Extracting shape parameters
est.par[attributes(est.par)$par.type=="shape"]

# evaluate the performance of the parameter estimation function by simulation
eval.estimation(rdist=rSSRTB,edist=eSSRTB,n = 1000, rep.num = 1e3,
params = list(shape1=2, shape2=5), method ="numerical.MLE")

# evaluate the precision of estimation by Hessian matrix
X <- rSSRTB(1000, shape1, shape2)
(est.par <- eSSRTB(X))
H <- attributes(eSSRTB(X, method = "numerical.MLE"))$nll.hessian
fisher_info <- solve(H)
sqrt(diag(fisher_info))

# log-likelihood, score vector and observed information matrix
lSSRTB(X,param = est.par)
lSSRTB(X,param = est.par, logL=FALSE)
}
}
\author{
Haizhen Wu and A. Jonathan R. Godfrey
}

