% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/Logistic.R
\name{Logistic}
\alias{Logistic}
\alias{dLogistic}
\alias{eLogistic}
\alias{lLogistic}
\alias{pLogistic}
\alias{qLogistic}
\alias{rLogistic}
\title{The Logistic Distribution.}
\usage{
dLogistic(x, location = 0, scale = 1, params = list(location = 0, scale =
  1), ...)

pLogistic(q, location = 0, scale = 1, params = list(location = 0, scale =
  1), ...)

qLogistic(p, location = 0, scale = 1, params = list(location = 0, scale =
  1), ...)

rLogistic(n, location = 0, scale = 1, params = list(location = 0, scale =
  1), ...)

eLogistic(X, w, method = "numerical.MLE", ...)

lLogistic(X, w, location = 0, scale = 1, params = list(location = 0, scale
  = 1), logL = TRUE, ...)
}
\arguments{
\item{x,q}{A vector of quantiles.}

\item{location}{Location parameter.}

\item{scale}{Scale parameter.}

\item{params}{A list that includes all named parameters.}

\item{...}{Additional parameters.}

\item{p}{A vector of probabilities.}

\item{n}{Number of observations.}

\item{X}{Sample observations.}

\item{w}{An optional vector of sample weights.}

\item{method}{Parameter estimation method.}

\item{logL}{logical; if TRUE, lLogistic gives the log-likelihood, otherwise the likelihood is given.}
}
\value{
dLogistic gives the density, pLogistic the distribution function,
qLogistic the quantile function, rLogistic generates random deviates, and
eLogistic estimates the parameters. lLogistic provides the log-likelihood function.
}
\description{
Density, distribution, and quantile, random number generation,
and parameter estimation functions for the logistic distribution with parameters \code{location} and \code{scale}.
Parameter estimation can be based on a weighted or unweighted i.i.d. sample and can be carried out numerically.
}
\details{
If \code{location} or \code{scale} are omitted, they assume the default values of 0 or 1
respectively. \cr
\cr
The \code{dLogistic()}, \code{pLogistic()}, \code{qLogistic()},and \code{rLogistic()} functions serve as wrappers of the
standard \code{\link[stats]{dlogis}}, \code{\link[stats]{plogis}}, \code{\link[stats]{qlogis}}, and
\code{\link[stats]{rlogis}} functions in the \pkg{\link{stats}} package. They allow for the parameters to be declared not only as
individual numerical values, but also as a list so parameter estimation can be carried out. \cr
\cr
The logistic distribution with \code{location} = \eqn{\alpha} and \code{scale} = \eqn{\beta} is most simply
defined in terms of its cumulative distribution function (Johnson et.al pp.115-116)
\deqn{F(x) =  1- [1 + exp((x-\alpha)/\beta)]^{-1}.}
The corresponding probability density function is given by
\deqn{f(x) = 1/\beta [exp(x-\alpha/\beta][1 + exp(x-\alpha/\beta)]^{-2}}
Parameter estimation is only implemented numerically. \cr
\cr
The score function and Fishers information are as given by Shi (1995) (See also Kotz & Nadarajah (2000)).
}
\examples{
# Parameter estimation for a distribution with known shape parameters
X <- rLogistic(n=500, location=1.5, scale=0.5)
est.par <- eLogistic(X); est.par
plot(est.par)
#  Fitted density curve and histogram
den.x <- seq(min(X),max(X),length=100)
den.y <- dLogistic(den.x,location=est.par$location,scale=est.par$scale)
hist(X, breaks=10, probability=TRUE, ylim = c(0,1.2*max(den.y)))
lines(den.x, den.y, col="blue")
lines(density(X), lty=2)

# Extracting location or scale parameters
est.par[attributes(est.par)$par.type=="location"]
est.par[attributes(est.par)$par.type=="scale"]

# log-likelihood function
lLogistic(X,param = est.par)

# Evaluation of the precision of the parameter estimates by the Hessian matrix
H <- attributes(est.par)$nll.hessian
fisher_info <- solve(H)
var <- sqrt(diag(fisher_info));var

# Example of parameter estimation for a distribution with
# unknown parameters currently been sought after.
}
\author{
Haizhen Wu and A. Jonathan R. Godfrey.\cr
Updates and bug fixes by Sarah Pirikahu.
}
\references{
Johnson, N. L., Kotz, S. and Balakrishnan, N. (1995) Continuous Univariate Distributions, volume 2,
 chapter 23. Wiley, New York.\cr
 \cr
 Shi, D. (1995) Fisher information for a multivariate extreme value distribution, Biometrika, vol 82, pp.644-649.\cr
 \cr
 Kotz, S. and Nadarajah (2000) Extreme Value Distributions Theory and Applications, chapter 3, Imperial Collage Press,
 Singapore.
}
\seealso{
\pkg{\link{ExtDist}} for other standard distributions.
}

