% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/Uniform.R
\name{Uniform}
\alias{Uniform}
\alias{dUniform}
\alias{eUniform}
\alias{lUniform}
\alias{pUniform}
\alias{qUniform}
\alias{rUniform}
\title{The Uniform Distribution.}
\usage{
dUniform(x, a = 0, b = 1, params = list(a, b), ...)

pUniform(q, a = 0, b = 1, params = list(a, b), ...)

qUniform(p, a = 0, b = 1, params = list(a, b), ...)

rUniform(n, a = 0, b = 1, params = list(a, b), ...)

eUniform(X, w, method = c("analytic.MLE", "moments", "numerical.MLE"), ...)

lUniform(X, w, a = 0, b = 1, params = list(a, b), logL = TRUE, ...)
}
\arguments{
\item{x,q}{A vector of quantiles.}

\item{a,b}{Boundary parameters.}

\item{params}{A list that includes all named parameters.}

\item{...}{Additional parameters.}

\item{p}{A vector of probabilities.}

\item{n}{Number of observations.}

\item{X}{Sample observations.}

\item{w}{An optional vector of sample weights.}

\item{method}{Parameter estimation method.}

\item{logL}{logical;if TRUE, lUniform gives the log-likelihood, otherwise the likelihood is given.}
}
\value{
dUniform gives the density, pUniform the distribution function,
qUniform the quantile function, rUniform generates random deviates, and
eUniform estimates the parameters. lUniform provides the log-likelihood function.
}
\description{
Density, distribution, quantile, random number
generation and parameter estimation functions for the uniform distribution on the interval
\eqn{[a,b]}.
Parameter estimation can be based on an unweighted i.i.d. sample only and can be performed analytically or
numerically.
}
\details{
If \code{a} or \code{b} are not specified they assume the default values of 0 and 1, respectively.\cr
\cr
The \code{dUniform()}, \code{pUniform()}, \code{qUniform()},and \code{rUniform()} functions serve as wrappers of the standard
\code{\link[stats]{dunif}}, \code{\link[stats]{punif}}, \code{\link[stats]{qunif}}, and \code{\link[stats]{runif}} functions
in the \pkg{\link{stats}} package. They allow for the parameters to be declared not only as
individual numerical values, but also as a list so parameter estimation can be carried out. \cr
\cr
The uniform distribution has probability density function
\deqn{p_x(x) = 1/(b-a)}
for \eqn{a \le x \le b}. The analytic maximum likelihood parameter estimates are as given by
\href{https://www.itl.nist.gov/div898/handbook/eda/section3/eda3662.htm}{Engineering Statistics Handbook}.
The method of moments parameter estimation option is also avaliable and the estimates are as given by Forbes et.al (2011), p.179.\cr
\cr
The log-likelihood function for the uniform distribution is given by
\deqn{l(a,b|x) = -n log(b-a)}
}
\note{
The analytical maximum likelihood estimation of the parameters \eqn{a} and \eqn{b} is calculated using the range and
mid-range of the sample. Therefore, only unweighted samples are catered for in the eUniform distribution when the method
\code{analytic.MLE} is selected.
}
\examples{
# Parameter estimation for a distribution with known shape parameters
X <- rUniform(n=500, a=0, b=1)
est.par <- eUniform(X, method="analytic.MLE"); est.par
plot(est.par)

# Histogram and fitted density
den.x <- seq(min(X),max(X),length=100)
den.y <- dUniform(den.x,a=est.par$a,b=est.par$b)
hist(X, breaks=10, probability=TRUE, ylim = c(0,1.2*max(den.y)))
lines(den.x, den.y, col="blue")  # Original data
lines(density(X), lty=2)         # Fitted curve

# Extracting boundary parameters
est.par[attributes(est.par)$par.type=="boundary"]

# log-likelihood
lUniform(X,param = est.par)

# Example of parameter estimation for a distribution with
# unknown parameters currently been sought after.
}
\author{
Haizhen Wu and A. Jonathan R. Godfrey.\cr
Updates and bugfixes by Sarah Pirikahu.
}
\references{
Johnson, N. L., Kotz, S. and Balakrishnan, N. (1995) Continuous Univariate Distributions,
 volume 2, chapter 26, Wiley, New York.\cr
 \cr
 \href{https://www.itl.nist.gov/div898/handbook/eda/section3/eda3662.htm}{Engineering Statistics Handbook}\cr
 \cr
 Forbes, C. Evans, M. Hastings, N. & Peacock, B. (2011) Statistical Distributions, 4th Ed, chapter 40, Wiley, New Jersey.\cr
}
\seealso{
\pkg{\link{ExtDist}} for other standard distributions.
}

