% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Gumbel.R
\name{Gumbel}
\alias{Gumbel}
\alias{dGumbel}
\alias{pGumbel}
\alias{qGumbel}
\alias{rGumbel}
\alias{eGumbel}
\alias{lGumbel}
\title{The Gumbel distribution}
\usage{
dGumbel(
  x,
  location = 0,
  scale = 1,
  params = list(location = 0, scale = 1),
  ...
)

pGumbel(
  q,
  location = 0,
  scale = 1,
  params = list(location = 0, scale = 1),
  ...
)

qGumbel(
  p,
  location = 0,
  scale = 1,
  params = list(location = 0, scale = 1),
  ...
)

rGumbel(
  n,
  location = 0,
  scale = 1,
  params = list(location = 0, scale = 1),
  ...
)

eGumbel(X, w, method = c("moments", "numerical.MLE"), ...)

lGumbel(
  X,
  w,
  location = 0,
  scale = 1,
  params = list(location = 0, scale = 1),
  logL = TRUE,
  ...
)
}
\arguments{
\item{x, q}{A vector of quantiles.}

\item{location}{Location parameter.}

\item{scale}{Scale parameter.}

\item{params}{A list that includes all named parameters}

\item{...}{Additional parameters.}

\item{p}{A vector of probabilities.}

\item{n}{Number of observations.}

\item{X}{Sample observations.}

\item{w}{An optional vector of sample weights.}

\item{method}{Parameter estimation method.}

\item{logL}{logical if TRUE, lGumbel gives the log-likelihood, otherwise the likelihood is given.}
}
\value{
dGumbel gives the density, pGumbel the distribution function,
qGumbel the quantile function, rGumbel generates random deviates, and
eGumbel estimate the distribution parameters. lGumbel provides the log-likelihood function.
}
\description{
Density, distribution, quantile, random number
generation, and parameter estimation functions for the Gumbel distribution with parameters
\code{location} and \code{scale}.
Parameter estimation can be based on a weighted or unweighted i.i.d sample and can be performed
analytically or numerically.
}
\details{
The \code{dGumbel()}, \code{pGumbel()}, \code{qGumbel()},and \code{rGumbel()} functions serve as wrappers of the
\code{\link[VGAM]{dgumbel}}, \code{\link[VGAM]{pgumbel}}, \code{\link[VGAM]{qgumbel}}, and \code{\link[VGAM]{rgumbel}} functions
in the \pkg{{VGAM}} package.They allow for the parameters to be declared not only as
individual numerical values, but also as a list so parameter estimation can be carried out. \cr
\cr
The Gumbel distribution is a special case of the generalised extreme value (GEV) distribution and
has probability density function,
\deqn{f(x) = exp{(-exp{-(x-\mu)/\sigma)}}}
where \eqn{\mu} = \code{location} and \eqn{\sigma} = \code{scale} which has the constraint \eqn{\sigma > 0}.
The analytical parameter estimations are as given by the \href{https://www.itl.nist.gov/div898/handbook/eda/section3/eda366g.htm}{Engineering Statistics Handbook}
with corresponding standard errors given by Bury (p.273).\cr
\cr
The log-likelihood function of the Gumbel distribution is given by
\deqn{l(\mu, \sigma| x) = \sigma^{-n} exp(-\sum (x_{i}-\mu/\sigma) - \sum exp(-(x_{i}-\mu/\sigma))).}
Shi (1995) provides the score function and Fishers information matrix.
}
\examples{
# Parameter estimation for a distribution with known shape parameters
X <- rGumbel(n = 500, location = 1.5, scale = 0.5)
est.par <- eGumbel(X, method="moments"); est.par
plot(est.par)

# Extracting location and scale parameters
est.par[attributes(est.par)$par.type=="location"]
est.par[attributes(est.par)$par.type=="scale"]

#  Fitted density curve and histogram
den.x <- seq(min(X),max(X),length=100)
den.y <- dGumbel(den.x, location = est.par$location, scale= est.par$scale)
hist(X, breaks=10, probability=TRUE, ylim = c(0,1.1*max(den.y)))
lines(den.x, den.y, col="blue")
lines(density(X))

# Parameter Estimation for a distribution with unknown shape parameters
# Example from; Bury(1999) pp.283-284, parameter estimates as given by Bury are location = 33.5
# and scale = 2.241
data <- c(32.7, 30.4, 31.8, 33.2, 33.8, 35.3, 34.6, 33, 32, 35.7, 35.5, 36.8, 40.8, 38.7, 36.7)
est.par <- eGumbel(X=data, method="numerical.MLE"); est.par
plot(est.par)

# log-likelihood
lGumbel(data, param = est.par)

# Evaluating the precision of the parameter estimates by the Hessian matrix
H <- attributes(est.par)$nll.hessian
var <- solve(H)
se <- sqrt(diag(var)); se
}
\references{
Johnson, N. L., Kotz, S. and Balakrishnan, N. (1995) Continuous Univariate Distributions,
 volume 2, chapter 22, Wiley, New York.\cr
 \cr
 \href{https://www.itl.nist.gov/div898/handbook/eda/section3/eda366g.htm}{Engineering Statistics Handbook}.\cr
 \cr
 Bury, K. (1999) Statistical Distributions in Engineering, Chapter 15, pp.283-284,
 Cambridge University Press.\cr
 \cr
 Shi, D. (1995). Multivariate extreme value distribution and its Fisher information matrix. Acta Mathematicae
}
\seealso{
\pkg{\link{ExtDist}} for other standard distributions.
}
\author{
Haizhen Wu and A. Jonathan R. Godfrey. \cr Updates and bug fixes by Sarah Pirikahu.
}
