% Generated by roxygen2 (4.0.1): do not edit by hand
\name{FADA}
\alias{FADA}
\title{Factor Adjusted Discriminant Analysis 2 : Supervised classification on decorrelated data}
\usage{
FADA(faobject,nfold.cv, nbf.cv=NULL, method = c("glmnet", "sda", "sparseLDA"), 
    sda.method = c("lfdr", "HC"), stop.par = 10, lambda, lambda.var, 
    lambda.freqs, diagonal = FALSE, alpha = 0.1,nfolds = 10)
}
\arguments{
\item{faobject}{An object returned by function \code{FA}.}

\item{nfold.cv}{Number of folds to estimate classification error rate, only when no testing data is provided. This function computes leave-one-out CV if \code{nfold.cv} is as large as the sample size and computes balanced cross validation otherwise. }

\item{nbf.cv}{Number of factors for cross validation to compute error rate, only when no testing data is provided. By default, \code{nbf = NULL} and the number of factors is estimated for each fold of the cross validation. \code{nbf} can
also be set to a positive integer value. If \code{nbf = 0}, the data are not factor-adjusted.}

\item{method}{The method used to perform supervised classification model. 3 options are available. If
\code{method = "glmnet"}, a Lasso penalized logistic regression is performed using \pkg{glmnet} R package.
If \code{method = "sda"}, a LDA or DDA (see \code{diagonal} argument) is performed using Shrinkage Discriminant
Analysis using \pkg{sda} R package. If \code{method = "sparseLDA"}, a Lasso penalized LDA is performed using
\pkg{SparseLDA} R package.}

\item{sda.method}{The method used for variable selection, only if \code{method="sda"}. If \code{sda.method="lfdr"},
variables are selected through CAT scores and False Non Discovery Rate control. If sda.method="HC", the variable selection
method is Higher Cristicism Thresholding.}

\item{stop.par}{This parameter controls the number of variables to include in the model, only if \code{method="sparseLDA"}.}

\item{lambda}{The shrinkage intensity of correlation matrix, if \code{method="sda"}.}

\item{lambda.var}{The shrinkage intensity of variances, if \code{method="sda"}.}

\item{lambda.freqs}{The shrinkage intensity of frequencies, if \code{method="sda"}.}

\item{diagonal}{If \code{diagonal = TRUE}, an assumption of independence is made and a shrunken diagonal discriminant
analysis is performed using \code{sda} R package. If \code{diagonal = FALSE}, FADA performs
shrunken linear discriminant analysis and takes into account correlations.}

\item{alpha}{The proportion of the HC objective to be observed, only if method="sda" and sda.method="HC". Default is 0.1.}

\item{nfolds}{Number of folds for estimation of lambda parameter in Lasso, which is used to estimate
individual probabilities. Default is \code{nfolds=10}. The smallest value is \code{nfolds = 3}. To perform
Leave-One-Out cross-validation,nfolds can be set to the size of training data, which is not advised for large
data sets. This option is used only when no testing data is available.}
}
\value{
Returns a list with the following elements:

\item{method}{Recall of the classification method}

\item{selected}{A vector containing index of the selected variables}

\item{proba.test}{A matrix containing predicted group frequencies of testing data, if a testing data set has been provided}

\item{predict.test}{A matrix containing predicted classes of testing data, if a testing data set has been provided}

\item{cv.error}{A numeric value containing the average classification error, computed by cross validation, if no testing data set has been provided}

\item{beta0}{A vector containing intercept parameters of the classification model}

\item{beta}{A matrix containing shape coefficients of the classification model}
}
\description{
This function performs supervised classification on factor-adjusted data.
}
\examples{
data(dta)
data(test)

# When testing data set is provided
res = FA(dta, test)
classif = FADA(res,method="sda",sda.method="lfdr")

### Not run 
# When no testing data set is provided
# res = FA(dta)
# classif = FADA(res,nfold.cv = 30, method="sda",sda.method="lfdr")
}
\author{
Emeline Perthame, Chloe Friguet and David Causeur
}
\references{
Ahdesmaki, M. and Strimmer, K. (2010), Feature selection in omics prediction problems using cat scores and false non-discovery rate control. Annals of Applied Statistics, 4, 503-519.

Clemmensen, L., Hastie, T. and Witten, D. and Ersboll, B. (2011), Sparse discriminant analysis. Technometrics, 53(4), 406-413.

Friedman, J., Hastie, T. and Tibshirani, R. (2010), Regularization paths for generalized linear models via coordinate descent. Journal of Statistical Software, 33, 1-22.

Friguet, C., Kloareg, M. and Causeur, D. (2009), A factor model approach to multiple testing under dependence. Journal of the American Statistical Association, 104:488, 1406-1415.

Perthame, E., Friguet, C. and Causeur, D. (2014), Stability of feature selection in classification issues for high-dimensional correlated data, Submitted.
}
\seealso{
\code{\link[FADA]{FADA}}, \code{\link[FADA]{FA}}, \code{\link[sparseLDA]{sda}}, \code{\link[sda]{sda-package}},
\code{\link[glmnet]{glmnet-package}}
}
