% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/external_functions.R
\name{replace_null_recursive}
\alias{replace_null_recursive}
\title{Replace NULL Values Recursively in a List}
\usage{
replace_null_recursive(lst, indices = character(0))
}
\arguments{
\item{lst}{A list or nested list where NULL values should be replaced.}

\item{indices}{A character vector used for recursive tracking of indices.
This should typically be left at its default value when the function is called.}
}
\value{
A list with NULL values replaced by NA.
}
\description{
This function recursively searches through a list or nested list
and replaces all NULL values with NA. It also records the path
where replacements occurred.
}
\examples{
# Example usage:
test_lst <- list(a = 1, b = NULL, c = list(d = 4, e = NULL))
replace_null_recursive(test_lst)

}
