% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aicc_weights_function.R
\name{aicc.weights}
\alias{aicc.weights}
\title{Plot evidence ratios}
\usage{
aicc.weights(input = getwd(), mrun = NULL, reorder = TRUE,
  save.output = NULL)
}
\arguments{
\item{input}{Either a string containing the directory which holds the "FAMoS-Results" folder or a matrix containing the tested models along with the respective information criteria. Default to \code{getwd()}.}

\item{mrun}{A string giving the number of the corresponding FAMoS run, e.g "004". If NULL (default), all FAMoS runs in the "FAMoS-Results/TestedModels/" folder will be used for evaluation.}

\item{reorder}{If TRUE, results will be ordered by evidence ratios (descending). If FALSE, the order of parameters will be the same as the order specified in \code{init.par} in \code{\link{famos}}. Default to TRUE.}

\item{save.output}{A string containing the location and name under which the figure should be saved (format is pdf). Default to NULL.}
}
\value{
A plot showing the evidence ratios for all model parameters. Additionally, the evidence ratios are returned.
}
\description{
Calculates the evidence ratios for each parameter based on Akaike weights and plots them.
}
\details{
The plot shows the relative support or evidence ratio for each parameter. Parameters included in the best model are printed bold and the corresponding lines are coloured in red.
}
\examples{
#plot evidence ratios
aicc.weights(input = famos.run)
aicc.weights(input = famos.run, reorder = FALSE)
}
