% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/mlp_teach.R
\name{mlp_teach_bp}
\alias{mlp_teach_bp}
\title{Backpropagation (batch) teaching}
\usage{
mlp_teach_bp(net, input, output, tol_level, max_epochs, report_freq = 0,
  learn_rate = 0.7)
}
\arguments{
\item{net}{an object of \code{mlp_net} class}

\item{input}{numeric matrix, each row corresponds to one input vector
number of columns must be equal to the number of neurons
in the network input layer}

\item{output}{numeric matrix with rows corresponding to expected outputs,
number of columns must be equal to the number of neurons
in the network output layer, number of rows must be equal to the number
of input rows}

\item{tol_level}{numeric value, error (MSE) tolerance level}

\item{max_epochs}{integer value, maximal number of epochs (iterations)}

\item{report_freq}{integer value, progress report frequency, if set to 0 no information is printed
on the console (this is the default)}

\item{learn_rate}{numeric value, learning rate in the backpropagation
       algorithm (default 0.7)}
}
\value{
Two-element list, the first field (\code{net}) contains trained network,
        the second (\code{mse}) - the learning history (MSE in consecutive epochs).
}
\description{
Backpropagation (a teaching algorithm) is a simple steepest
descent algorithm for MSE minimisation, in which weights are updated according
to (scaled) gradient of MSE.
}
\note{
The name `backpropagation' is commonly used in two contexts, which
sometimes causes confusion. Firstly, backpropagation can be understood as
an efficient algorithm for MSE gradient computation that was first described
by Bryson and Ho in the '60s of 20th century and reinvented in the '80s.
Secondly, the name backpropagation is (more often) used to refer to the steepest
descent method that uses gradient of MSE computed efficiently by means
of the aforementioned algorithm. This ambiguity is probably caused by the fact
that in practically all neural network implementations, the derivatives of MSE
and weight updates are computed simultaneously in one backward pass (from
output layer to input layer).
}
\references{
A.E. Bryson and Y.C. Ho. \emph{Applied optimal control: optimization, estimation,
and control. Blaisdell book in the pure and applied sciences.} Blaisdell Pub. Co., 1969.

David E. Rumelhart, Geoffrey E. Hinton, and Ronald J. Williams. \emph{Learning representations
by back-propagating errors.} Nature, 323(6088):533-536, October 1986.
}
\keyword{teaching}

