% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mlp_net.R
\name{mlp_set_activation}
\alias{mlp_set_activation}
\title{Set network activation functions}
\usage{
mlp_set_activation(net, layer, activation = c("threshold", "sym_threshold",
  "linear", "sigmoid", "sym_sigmoid", "tanh", "sigmoid_approx",
  "sym_sigmoid_approx"), slope = 0)
}
\arguments{
\item{net}{an object of \code{mlp_net} class}

\item{layer}{integer vector or character value, index (indices) of layer(s)
whose activation function will be changed or character:
"a" denotes all layers, "h" - hidden layer(s), "o" - the output layer}

\item{activation}{character string, activation function name, admissible
options are: "threshold", "sym_threshold", "linear",
"sigmoid", "sym_sigmoid" (and "tanh"), "sigmoid_approx",
and "sym_sigmoid_approx"}

\item{slope}{numeric value, activation function slope parameter, if 0
the default parameter value is chosen for each activation function}
}
\value{
This function returns network (an object of \code{mlp_net} class)
        with activation function set.
}
\description{
This function sets activation function (and its slope parameter)
for neurons in the hidden layers and in the output layer.
}

