% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mlp_teach.R
\name{mlp_teach_sgd}
\alias{mlp_teach_sgd}
\title{Stochastic gradient descent with (optional) RMS weights scaling, weight
decay, and momentum}
\usage{
mlp_teach_sgd(net, input, output, tol_level, max_epochs, learn_rate,
  l2reg = 0, minibatchsz = 100, lambda = 0, gamma = 0, momentum = 0,
  report_freq = 0)
}
\arguments{
\item{net}{an object of \code{mlp_net} class}

\item{input}{numeric matrix, each row corresponds to one input vector
number of columns must be equal to the number of neurons
in the network input layer}

\item{output}{numeric matrix with rows corresponding to expected outputs,
number of columns must be equal to the number of neurons
in the network output layer, number of rows must be equal to the number
of input rows}

\item{tol_level}{numeric value, error (MSE) tolerance level}

\item{max_epochs}{integer value, maximal number of epochs (iterations)}

\item{learn_rate}{numeric value, (initial) learning rate, depending
on the problem at hand, learning rates of 0.001 or 0.01 should
give satisfactory convergence}

\item{l2reg}{numeric value, L2 regularization parameter (default 0)}

\item{minibatchsz}{integer value, the size of the mini batch (default 100)}

\item{lambda}{numeric value, rmsprop parameter controlling the update
of mean squared gradient, reasonable value is 0.1 (default 0)}

\item{gamma}{numeric value, weight decay parameter (default 0)}

\item{momentum}{numeric value, momentum parameter, reasonable values are
between 0.5 and 0.9 (default 0)}

\item{report_freq}{integer value, progress report frequency, if set to 0
no information is printed on the console (this is the default)}
}
\value{
Two-element list, the first field (\code{net}) contains the trained network,
        the second (\code{mse}) - the learning history (MSE in consecutive epochs).
}
\description{
This function implements the stochastic gradient descent method with
optional modifications: L2 regularization, root mean square gradient scaling, weight decay,
and momentum.
}
\keyword{teaching}

