% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitFCS.R
\name{fitFCS}
\alias{fitFCS}
\title{Fitting FCS Data}
\usage{
fitFCS(data = parent.frame(), start, low = -Inf, up = Inf, type = "D3D", trace = TRUE)
}
\arguments{
\item{data}{data frame in which to evaluate the variables in formula and weights.}

\item{start}{a named list or named numeric vector of starting estimates.}

\item{low, up}{a named list or named numeric vector of lower and upper bounds, replicated to be as long as start. If unspecified, all parameters are assumed to be -Inf and Inf.}

\item{type}{specification for the equation to model, is a character string. The default value is "D3D" equation for three-dimensional free diffusion.
Another possibles values are: "D2D" for two-dimensional free diffusion,  "D2DT" for two-dimensional free diffusion with triplet exited state, and "D3DT" for three-dimensional free diffusion with triplet exited state.}

\item{trace}{logical value that indicates whether the progress of the non-linear regression (nls) should be printed.}
}
\value{
A nls object (from nls).
}
\description{
Estimates the parameters based on a given equation, on the data generated with the fcs() function.
}
\details{
The autocorrelation function contains information about the molecular diffusion coefficient and the number of molecules occupying the observation volume. To interpret such data in molecular terms we need a model to describe the fluctuations. The model of free diffusion in three dimensions:
G(tau)=G(0)((1+(tau/tau_D))^(-1))(1+((s/u)^2)(tau/tau_D))^(-1/2), with tau_D=(s^2)/4D
where tau_D is the diffusion time, s is the radius and u = ks.
So, if "D3D" is selected, the variables that should be considered are G (resulting value of the fcs function), tau the vector of time in the correlation function, s the PSF (Point Spread Function) radius, k the scalar factor between the radius half-length of the PSF, D is the diffusion coefficent and the G(0) is inversely proportional to the molecular concentration.
}
\examples{
g <- fcs(x = Cy5_1nM$f)
len <- 1:length(g)

df <- data.frame(g = g, tau = Cy5_1nM$t[len], s = 0.25, k = 3)
start <- list(D = 100, G0 = 0.1)
low <- list(D = 1E-1, G0 = 1E-2)
up  <- list(D = 500, G0 = 100)

modelFCS <- fitFCS(data = df, start = start, low = low, up = up, type = "D3D")
fit <- predict(modelFCS, list(tau = Cy5_1nM$t[len]))

plot(y = g, x = Cy5_1nM$t[len], log = 'x', type = 'l', xlab = expression(tau(mu~s)),
ylab = expression(G(tau)), main = "Symulation of Cy5 [1nM]")
lines(fit~Cy5_1nM$t[len], col = "blue")
}
\seealso{
\code{\link{nls}}, \code{\link{fcs}}
}
\author{
Raul Pinto Camara
}
