% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FCVAR_post.R
\name{FCVARhypoTest}
\alias{FCVARhypoTest}
\title{Test of Restrictions on FCVAR Model}
\usage{
FCVARhypoTest(modelUNR, modelR)
}
\arguments{
\item{modelUNR}{A list of estimation results created for the unrestricted model.}

\item{modelR}{A list of estimation results created for the restricted model.}
}
\value{
A list \code{LRtest} containing the test results,
including the following parameters:
\describe{
  \item{\code{loglikUNR}}{The log-likelihood for the unrestricted model.}
  \item{\code{loglikR}}{The log-likelihood for the restricted model.}
  \item{\code{df}}{The degrees of freedom for the test.}
  \item{\code{LRstat}}{The likelihood ratio test statistic.}
  \item{\code{p_LRtest}}{The p-value for the likelihood ratio test.}
}
}
\description{
\code{FCVARhypoTest} performs a likelihood ratio test of the null
	hypothesis: "model is \code{modelR}" against the alternative hypothesis:
	"model is \code{modelUNR}".
}
\examples{
\donttest{
opt <- FCVARoptions()
opt$gridSearch   <- 0 # Disable grid search in optimization.
opt$dbMin        <- c(0.01, 0.01) # Set lower bound for d,b.
opt$dbMax        <- c(2.00, 2.00) # Set upper bound for d,b.
opt$constrained  <- 0 # Impose restriction dbMax >= d >= b >= dbMin ? 1 <- yes, 0 <- no.
x <- votingJNP2014[, c("lib", "ir_can", "un_can")]
m1 <- FCVARestn(x, k = 2, r = 1, opt)
opt1 <- opt
opt1$R_psi <- matrix(c(1, 0), nrow = 1, ncol = 2)
opt1$r_psi <- 1
m1r1 <- FCVARestn(x, k = 2, r = 1, opt1)
Hdb <- FCVARhypoTest(modelUNR = m1, modelR = m1r1)
}

\donttest{
opt1 <- opt
opt1$R_Beta <- matrix(c(1, 0, 0), nrow = 1, ncol = 3)
m1r2 <- FCVARestn(x, k = 2, r = 1, opt1)
Hbeta1 <- FCVARhypoTest(m1, m1r2)
}

\donttest{
opt1 <- opt
opt1$R_Alpha <- matrix(c(0, 1, 0), nrow = 1, ncol = 3)
m1r4 <- FCVARestn(x, k = 2, r = 1, opt1)
Halpha2 <- FCVARhypoTest(m1, m1r4)
}
}
\seealso{
The test is calculated using the results of two calls to
\code{FCVARestn}, under the restricted and unrestricted models.
Use \code{FCVARoptions} to set default estimation options for each model,
then set restrictions as needed before \code{FCVARestn}.

Other FCVAR postestimation functions: 
\code{\link{FCVARboot}()},
\code{\link{GetCharPolyRoots}()},
\code{\link{MVWNtest}()},
\code{\link{plot.FCVAR_roots}()},
\code{\link{summary.FCVAR_roots}()},
\code{\link{summary.MVWN_stats}()}
}
\concept{FCVAR postestimation functions}
