% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FCVAR_aux.R
\name{FCVARsimBS}
\alias{FCVARsimBS}
\title{Draw Bootstrap Samples from the FCVAR Model}
\usage{
FCVARsimBS(data, model, NumPeriods)
}
\arguments{
\item{data}{A \eqn{T x p} matrix of starting values for the simulated realizations.}

\item{model}{A list of estimation results, just as if estimated from \code{FCVARest}.
The parameters in \code{model} can also be set or adjusted by assigning new values.}

\item{NumPeriods}{The number of time periods in the simulation.}
}
\value{
A \code{NumPeriods} by \eqn{p} matrix \code{xBS} of simulated bootstrap values.
}
\description{
\code{FCVARsimBS} simulates the FCVAR model as specified by
input \code{model} and starting values specified by \code{data}.
It creates a wild bootstrap sample by augmenting each iteration
with a bootstrap error. The errors are sampled from the
residuals specified under the \code{model} input and have a
positive or negative sign with equal probability (the Rademacher distribution).
}
\examples{
\donttest{
opt <- FCVARoptions()
opt$gridSearch   <- 0 # Disable grid search in optimization.
opt$dbMin        <- c(0.01, 0.01) # Set lower bound for d,b.
opt$dbMax        <- c(2.00, 2.00) # Set upper bound for d,b.
opt$constrained  <- 0 # Impose restriction dbMax >= d >= b >= dbMin ? 1 <- yes, 0 <- no.
x <- votingJNP2014[, c("lib", "ir_can", "un_can")]
results <- FCVARestn(x, k = 2, r = 1, opt)
xBS <- FCVARsimBS(x[1:10, ], results, NumPeriods = 100)
}
}
\seealso{
\code{FCVARoptions} to set default estimation options.
\code{FCVARestn} for the specification of the \code{model}.
Use \code{FCVARsim} to draw a sample from the FCVAR model.
For simulations intended for bootstrapping statistics, use \code{FCVARsimBS}.

Other FCVAR auxiliary functions: 
\code{\link{FCVARforecast}()},
\code{\link{FCVARlikeGrid}()},
\code{\link{FCVARsim}()},
\code{\link{FracDiff}()},
\code{\link{plot.FCVAR_grid}()}
}
\concept{FCVAR auxiliary functions}
