% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.p.fdr.R
\name{plot.p.fdr}
\alias{plot.p.fdr}
\title{FDR plotting}
\usage{
\method{plot}{p.fdr}(
  x,
  raw.pvalues = TRUE,
  adj.pvalues = TRUE,
  sig.line = TRUE,
  adj.sig.line = TRUE,
  threshold = NA,
  x.axis = "Rank",
  xlim = NA,
  ylim = c(0, 1),
  zvalues = "two.sided",
  legend.where = NA,
  legend.on = TRUE,
  main = NA,
  pch.adj.p = 17,
  pch.raw.p = 20,
  pch.adj.fdr = 20,
  col = c("dodgerblue", "firebrick2", "black"),
  ...
)
}
\arguments{
\item{x}{A p.fdr object that contains the list of output.}

\item{raw.pvalues}{A Boolean TRUE or FALSE value to indicate whether or not to plot the raw p-value points. Defaults to TRUE.}

\item{adj.pvalues}{A Boolean TRUE or FALSE value to indicate whether or not to plot the adjusted p-value points. Defaults to TRUE.}

\item{sig.line}{A Boolean TRUE or FALSE value to indicate whether or not to plot the raw p-value significance line. Defaults to TRUE.}

\item{adj.sig.line}{A Boolean TRUE or FALSE value to indicate whether or not to plot the adjusted significance threshold. Defaults to TRUE.}

\item{threshold}{A numeric value to determine the threshold at which we plot significance. Defaults to value used in the p.fdr.object.}

\item{x.axis}{A string variable to indicate what to plot on the x-axis. Can either be "Rank" or "Zvalues". Defaults to "Rank".}

\item{xlim}{A numeric interval for x-axis limits.}

\item{ylim}{A numeric interval for y-axis limits. Defaults to c(0,1).}

\item{zvalues}{A numeric vector of z-values to be used in pi0 estimation or a string with options "two.sided", "greater" or "less". Defaults to "two.sided".}

\item{legend.where}{A string "bottomright", "bottomleft", "topleft", "topright". Defaults to "topleft" is x.axis="Rank" and "topright" if x.axis="Zvalues".}

\item{legend.on}{A Boolean TRUE or FALSE value to indicate whether or not to print the legend.}

\item{main}{A string variable for the title of the plot.}

\item{pch.adj.p}{A plotting "character’, or symbol to use for the adjusted p-value points. This can either be a single character or an integer code for one of a set of graphics symbols. Defaults to 17.}

\item{pch.raw.p}{A plotting "character’, or symbol to use for the raw p-value points. This can either be a single character or an integer code for one of a set of graphics symbols. Defaults to 20.}

\item{pch.adj.fdr}{A plotting "character’, or symbol to use for the adjusted FDR points. This can either be a single character or an integer code for one of a set of graphics symbols. Defaults to 20.}

\item{col}{A vector of colors for the points and lines in the plot. If the input has 1 value all points and lines will be that same color. If the input has length of 3 then col.adj.fdr will be the first value, col.adj.p will be the second, and col.raw.p is the third. Defaults to c("dodgerblue","firebrick2", "black").}

\item{...}{Graphical parameters. Any argument that can be passed to image.plot and to base plot, such as axes=FALSE, main='title', ylab='latitude'}
}
\description{
This function creates a plot using a x (p.fdr.object).
}
\details{
We run into errors or warnings when zvalues or col are inputted incorrectly.
}
\examples{

# Example 1

sim.data.p = c(runif(80),runif(20, min=0, max=0.01))
fdr.output = p.fdr(pvalues=sim.data.p)

plot(fdr.output)
plot(fdr.output, x.axis="Zvalues")


}
\references{
\insertRef{Rpack:bibtex}{Rdpack}

\insertRef{R}{FDRestimation}

\insertRef{bh:1995}{FDRestimation}

\insertRef{by:2001}{FDRestimation}

\insertRef{holm:1979}{FDRestimation}

\insertRef{hoch:1988}{FDRestimation}

\insertRef{sidak:1967}{FDRestimation}

\insertRef{bon:1936}{FDRestimation}

\insertRef{murray2020false}{FDRestimation}
}
\seealso{
\code{\link{summary.p.fdr}, \link{p.fdr}, \link{get.pi0}}
}
\concept{plot FDR adjusted p-values}
\keyword{FDR}
\keyword{p-values}
\keyword{plot}
