% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FDX-package.R
\docType{package}
\name{FDX-package}
\alias{FDX}
\alias{FDX-package}
\title{False Discovery Exceedance (FDX) Control for Heterogeneous and Discrete Tests}
\description{
This package implements the [HLR], [HGR] and [HPB] procedures for both
heterogeneous and discrete tests (see Reference).
}
\details{
The functions are reorganized from the reference paper in the following way.
\code{\link[=discrete.LR]{discrete.LR()}} (for Discrete Lehmann-Romano) implements [DLR],
\code{\link[=discrete.GR]{discrete.GR()}} (for Discrete Guo-Romano) implements [DGR] and
\code{\link[=discrete.PB]{discrete.PB()}} (for Discrete Poisson-Binomial) implements [DPB].
\code{\link[=DLR]{DLR()}} and \code{\link[=NDLR]{NDLR()}} are wrappers for \code{\link[=discrete.LR]{discrete.LR()}} to access
[DLR] and its non-adaptive version directly. Likewise, \code{\link[=DGR]{DGR()}},
\code{\link[=NDGR]{NDGR()}}, \code{\link[=DPB]{DPB()}} and \code{\link[=NDPB]{NDPB()}} are wrappers for
\code{\link[=discrete.GR]{discrete.GR()}} and \code{\link[=discrete.PB]{discrete.PB()}}, respectively. Their main
parameters are a vector of raw observed p-values and a list of the same
length, whose elements are the discrete supports of the CDFs of the p-values.

In the same fashion, \code{\link[=weighted.LR]{weighted.LR()}} (for Weighted Lehmann-Romano),
\code{\link[=weighted.GR]{weighted.GR()}} (for Weighted Guo-Romano) and \code{\link[=weighted.PB]{weighted.PB()}}
(for Weighted Poisson-Binomial) implement [wLR], [wGR] and [wGR],
respectively. They also possess wrapper functions, namely \code{\link[=wLR.AM]{wLR.AM()}},
\code{\link[=wGR.AM]{wGR.AM()}} and \code{\link[=wPB.AM]{wPB.AM()}} for arithmetic weighting, and \code{\link[=wLR.GM]{wLR.GM()}},
\code{\link[=wPB.GM]{wPB.GM()}} and \code{\link[=wPB.GM]{wPB.GM()}} for geometric weighting.

The functions \code{\link[=fast.Discrete.LR]{fast.Discrete.LR()}}, \code{\link[=fast.Discrete.GR]{fast.Discrete.GR()}}
and \code{\link[=fast.Discrete.PB]{fast.Discrete.PB()}} are wrappers for
\code{\link[DiscreteFDR:fisher.pvalues.support]{DiscreteFDR::fisher.pvalues.support()}} and \code{\link[=discrete.LR]{discrete.LR()}},
\code{\link[=discrete.GR]{discrete.GR()}} and \code{\link[=discrete.PB]{discrete.PB()}}, respectively, which allow to apply
discrete procedures directly to a data set of contingency tables.
}
\references{
Döhler, S. & Roquain, E. (2020). Controlling False Discovery Exceedance for
Heterogeneous Tests. \emph{Electronic Journal of Statistics}, \emph{14}(2),
pp. 4244-4272. \doi{10.1214/20-EJS1771}

Lehmann, E. L. & Romano, J. P. (2005). Generalizations of the familywise
error rate. \emph{The Annals of Statistics}, \emph{33}(3), pp. 1138-1154.
\doi{10.1214/009053605000000084}

Guo, W. & Romano, J. P. (2007). A generalized Sidak-Holm procedure and
control of generalized error rates under independence.
\emph{Statistical Applications in Genetics and Molecular Biology}, \emph{6}(1),
Art. 3, 35 pp. (eletronic). \doi{10.2202/1544-6115.1247}
}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/DISOhda/FDX}
  \item Report bugs at \url{https://github.com/DISOhda/FDX/issues}
}

}
\author{
\strong{Maintainer}: Florian Junge \email{florian.junge@h-da.de}

Authors:
\itemize{
  \item Sebastian Döhler
}

Other contributors:
\itemize{
  \item Etienne Roquain [contributor]
}

}
