% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/methods.R
\name{update.FDboost}
\alias{update.FDboost}
\title{Function to update FDboost objects}
\usage{
\method{update}{FDboost}(object, weights = NULL, oobweights = NULL,
  risk = NULL, trace = NULL, ..., evaluate = TRUE)
}
\arguments{
\item{object}{fitted FDboost-object}

\item{weights,oobweights,risk,trace}{see \code{?FDboost}}

\item{...}{Additional arguments to the call, or arguments with changed values.}

\item{evaluate}{If true evaluate the new call else return the call.}
}
\value{
Returns the call of (\code{evaluate = FALSE}) or the updated (\code{evaluate = TRUE}) FDboost model
}
\description{
Function to update FDboost objects
}
\examples{
######## Example from \\code{?FDboost}
data("viscosity", package = "FDboost")
## set time-interval that should be modeled
interval <- "101"

## model time until "interval" and take log() of viscosity
end <- which(viscosity$timeAll == as.numeric(interval))
viscosity$vis <- log(viscosity$visAll[,1:end])
viscosity$time <- viscosity$timeAll[1:end]
# with(viscosity, funplot(time, vis, pch = 16, cex = 0.2))

mod1 <- FDboost(vis ~ 1 + bolsc(T_C, df = 2) + bolsc(T_A, df = 2),
               timeformula = ~ bbs(time, df = 4),
               numInt = "equal", family = QuantReg(),
               offset = NULL, offset_control = o_control(k_min = 9),
               data = viscosity, control=boost_control(mstop = 10, nu = 0.4))

# update nu
mod2 <- update(mod1, control=boost_control(nu = 1)) # mstop will stay the same
# update mstop
mod3 <- update(mod2, control=boost_control(mstop = 100)) # nu=1 does not get changed
mod4 <- update(mod1, formula = vis ~ 1 + bolsc(T_C, df = 2)) # drop one term
}
\author{
David Ruegamer
}

