% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/baselearners.R
\name{integrationWeights}
\alias{integrationWeights}
\alias{integrationWeightsLeft}
\title{Functions to compute integration weights}
\usage{
integrationWeights(X1, xind, id = NULL)

integrationWeightsLeft(X1, xind, leftWeight = c("first", "mean", "zero"))
}
\arguments{
\item{X1}{for functional data that is observed on one common grid, 
a matrix containing the observations of the functional variable. 
For a functional variable that is observed on curve specific grids, a long vector.}

\item{xind}{evaluation points (index) of functional variable}

\item{id}{defaults to \code{NULL}. Only necessary for response in long format. 
In this case \code{id} specifies which curves belong together.}

\item{leftWeight}{one of \code{c("mean", "first", "zero")}. With left Riemann sums 
different assumptions for the weight of the first observation are possible. 
The default is to use the mean over all integration weights, \code{"mean"}. 
Alternatively one can use the first integration weight, \code{"first"}, or 
use the distance to zero, \code{"zero"}.}
}
\description{
Computes trapezoidal integration weights (Riemann sums) for a functional variable 
\code{X1} that has evaluation points \code{xind}.
}
\details{
The function \code{integrationWeights()} computes trapezoidal integration weights, 
that are symmetric. Per default those weights are used in the \code{\link{bsignal}}-base-learner. 
In the special case of evaluation points (\code{xind}) with equal distances, 
all integration weights are equal.
  
The function \code{integrationWeightsLeft()} computes weights,
that take into account only the distance to the prior observation point. 
Thus one has to decide what to do with the first observation. 
The left weights are adequate for historical effects like in \code{\link{bhist}}.
}
\examples{
## Example for trapezoidal integration weights
xind0 <- seq(0,1,l = 5)
xind <- c(0, 0.1, 0.3, 0.7, 1)
X1 <- matrix(xind^2, ncol = length(xind0), nrow = 2)

# Regualar observation points
integrationWeights(X1, xind0)
# Irregular observation points
integrationWeights(X1, xind)

# with missing value
X1[1,2] <- NA
integrationWeights(X1, xind0)
integrationWeights(X1, xind)

## Example for left integration weights
xind0 <- seq(0,1,l = 5)
xind <- c(0, 0.1, 0.3, 0.7, 1)
X1 <- matrix(xind^2, ncol = length(xind0), nrow = 2)

# Regular observation points
integrationWeightsLeft(X1, xind0, leftWeight = "mean") 
integrationWeightsLeft(X1, xind0, leftWeight = "first") 
integrationWeightsLeft(X1, xind0, leftWeight = "zero")

# Irregular observation points
integrationWeightsLeft(X1, xind, leftWeight = "mean") 
integrationWeightsLeft(X1, xind, leftWeight = "first") 
integrationWeightsLeft(X1, xind, leftWeight = "zero")

# obervation points that do not start with 0
xind2 <- xind + 0.5
integrationWeightsLeft(X1, xind2, leftWeight = "zero")
 
}
\seealso{
\code{\link{bsignal}} and \code{\link{bhist}} for the base-learners.
}
