% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spGetXY.R
\name{spGetXY}
\alias{spGetXY}
\title{Spatial wrapper - Extracts XY coordinates within a given boundary.}
\usage{
spGetXY(
  bnd,
  bnd_dsn = NULL,
  bnd.filter = NULL,
  states = NULL,
  RS = NULL,
  xy_datsource = "datamart",
  xy = NULL,
  xy_dsn = NULL,
  xy.uniqueid = "PLT_CN",
  xvar = NULL,
  yvar = NULL,
  xy.crs = 4269,
  xyjoinid = NULL,
  pjoinid = "CN",
  clipxy = TRUE,
  plot_layer = "plot",
  evalid = NULL,
  evalCur = FALSE,
  evalEndyr = NULL,
  measCur = FALSE,
  measEndyr = NULL,
  measEndyr.filter = NULL,
  invyrs = NULL,
  measyrs = NULL,
  allyrs = FALSE,
  intensity1 = FALSE,
  showsteps = FALSE,
  returnxy = TRUE,
  savedata = FALSE,
  exportsp = FALSE,
  savedata_opts = NULL
)
}
\arguments{
\item{bnd}{sf R object, Area of Interest (AOI) boundary. Can be a spatial sf
object, full pathname to a shapefile, or name of a layer within a database.}

\item{bnd_dsn}{String. Data source name (dsn; e.g., SQLite database or shapefile
pathname) of bnd. The dsn varies by driver. See gdal OGR vector formats
(https://www.gdal.org/ogr_formats.html). Optional if bnd is an R object.}

\item{bnd.filter}{String. Filter to subset bnd spatial layer.}

\item{states}{String. The name of state(s) for tables (e.g., "Vermont",
"Utah").}

\item{RS}{String. Name of FIA research station to restrict states to
('RMRS','SRS','NCRS','NERS','PNWRS'). If NULL, all research stations are
included.}

\item{xy_datsource}{String. Source of XY data ("obj", "csv", "datamart",
"sqlite").  If datsource=NULL, checks extension of xy_dsn or xy to identify
datsource.}

\item{xy}{sf R object or String. Table with xy coordinates. Can be a spatial
polygon object, data frame, full pathname to a shapefile, or name of a layer
within a database.}

\item{xy_dsn}{String. Data source name (dsn; i.e., pathname or database
name) of xy. The dsn varies by driver. See gdal OGR vector formats
(https://www.gdal.org/ogr_formats.html). Optional if bnd_layer is an R
object.}

\item{xy.uniqueid}{String. Unique identifier of xy.}

\item{xvar}{String. Name of variable in xyplt defining x coordinate.}

\item{yvar}{String. Name of variable in xyplt defining y coordinate.}

\item{xy.crs}{PROJ.4 String or CRS object or Integer EPSG code defining
Coordinate Reference System.}

\item{xyjoinid}{String. Variable in xy to join to plot data. If NULL,
xyjoinid=xy.uniqueid.}

\item{pjoinid}{String. Variable in plt to join to XY data. Not necessary to
be unique. If using most current XY coordinates, use identifier for a plot
(e.g., PLOT_ID).}

\item{clipxy}{Logical. If TRUE, clips xy data to bnd.}

\item{plot_layer}{String. Name of plot_layer in database.}

\item{evalid}{Integer. To extract data for a specific evaluation period. See
notes for more information about FIA Evaluations.}

\item{evalCur}{Logical. If TRUE, extract plots with most current FIA
Evalidation for state(s).}

\item{evalEndyr}{Integer. Defining end year of Evaluation (yyyy).}

\item{measCur}{Logical. If TRUE, extract plots with most current measurement
for state(s).}

\item{measEndyr}{Integer year (YYYY). If measCur=TRUE, extract plots with
most current measurement for state(s) for years measured before measEndyr.}

\item{measEndyr.filter}{Filter. If measCur=TRUE and measEndyr != NULL, a
filter for bnd to identify and area to use measEndyr, such as disturbed
areas where you want to exclude plots measured after disturbance.}

\item{invyrs}{Integer vector. Defining specific inventory years of data
(e.g., 2010:2015).}

\item{measyrs}{Integer vector. Defining specific measurement years of data
(e.g., 2010:2015).}

\item{allyrs}{Logical. If TRUE, selects all years (annual inventory) in
database.}

\item{intensity1}{Logical. If TRUE, include only single intensity plots
(i.e., INTENSITY = 1).}

\item{showsteps}{Logical. If TRUE, display data in device window.}

\item{returnxy}{Logical. If TRUE, returns XY coordinates.}

\item{savedata}{Logical. If TRUE, saves data to outfolder. Note:
includes XY data if returnxy = TRUE.}

\item{exportsp}{Logical. If savedata = TRUE and returnxy = TRUE, 
if TRUE, exports XY data as spatial data.}

\item{savedata_opts}{List. See help(savedata_options()) for a list
of options. Only used when savedata = TRUE.}
}
\value{
\item{spxy}{ sf. If returnxy=TRUE, spatial xy point data. }
\item{pltids}{ data frame. A table of pltids that are within bnd. }
\item{spxy}{ sf data frame. If returnxy, a simple feature with pltids within bnd. }
\item{bndx}{ sf object. Input bnd. } 
\item{xy.uniqueid}{ String. Unique identifier of plots in xy. } 
\item{states}{ String. Vector of states that intersect bnd. } 
\item{countyfips}{ String. Vector of countyfips values that intersect bnd. } 
\item{stbnd.att}{ String. Name of state attribute used to select plots. }

If savedata=TRUE and returnxy=TRUE, the plt data frame, including XY 
coordinates is saved to outfolder (xyplt).\cr 
If savedata=TRUE and returnxy=FALSE, the plt data frame, without XY 
coordinates is saved to outfolder (pltids).\cr
If savedata=TRUE and returnxy=TRUE and exportsp=TRUE, the spxy sf object is 
exported as shapefile to outfolder.\cr
}
\description{
Wrapper to get FIA plots within the boundary population (area of interest) -
Intersect with state boundary - Get FIA plots for intersected states,
including tree, and spatial - Clip spatial coordinates and other tables to
boundary (spClipPoint)
}
\details{
\bold{datsource}

Plots are extracted from 3 different data sources:\cr 1) CSV - data have
previously been extracted from the FIA database and stored as CSV files.\cr
2) datamart - data are extracted from FIA's publically-available
datamart.\cr 3) sqlite - data have previously been extracted from the FIA
database and stored within a SQLite database.\cr

\bold{Selection parameters}

FIA plots are selected based on the following parameters:\cr \tabular{ll}{
\tab evalid - the FIA evaluation identifier\cr \tab evalCur - the most
current FIA evaluation in database\cr \tab evalEndyr - the FIA evaluation
ending in evalEndyr\cr \tab evalType - the FIA evaluation type ('ALL',
'AREAVOL', 'GRM', 'P2VEG', 'DWM', 'INV', 'REGEN', 'CRWN')\cr \tab measCur -
the most current measurement of each plot in database\cr \tab measEndyr -
the most current measuremtn of each plot in database in or prior to
measEndyr\cr \tab Endyr.filter - a filter for bnd that specifies the
boundary where measEndyr should be applied\cr }
}
\note{
If savebnd=TRUE:\cr If out_fmt=c('csv','shp'), the writeOGR (rgdal) function
is called. The ArcGIS driver truncates variable names to 10 characters or
less. Variable names are changed before export using an internal function
(trunc10shp). If Spatial object has more than 1 record, it will be returned
but not exported.

If datsource="datmart", (default), data are imported from FIA DataMart.  The
plot coordinates have been altered for privacy (See
https://www.fia.fs.fed.us/tools-data/spatial/Policy/index.php for details).
The zip files are extracted on-the-fly from the online website. Web server
connections will affect download speeds.
}
\examples{
\dontrun{
# Set up data from FIESTA
WYbhfn <- system.file("extdata",
                      "sp_data/WYbighorn_adminbnd.shp",
                      package = "FIESTA")
# Use spGetXY
WYbhxy <- spGetXY(bnd = WYbhfn,
                  xy_datsource = "datamart",
                  evalCur = TRUE,
                  returnxy = TRUE)
}
}
\author{
Tracey S. Frescino
}
\keyword{data}
