% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DBinternal.R, R/Ratio2Size.R, R/addCI.R,
%   R/change10char.R, R/cool_functions.R, R/cool_spfunctions.R,
%   R/fileexistsnm.R, R/getRefcodes.R, R/getRefobject.R, R/getadjfactorGB.R,
%   R/getadjfactorPLOT.R, R/getfunnm.R, R/getlt10char.R, R/getrhat.R,
%   R/groupStrata.R, R/groupUnits.R, R/internal_desc.R, R/save1tab.R,
%   R/save2tabs.R, R/strat_collapse.R, R/table_functions.R, R/vector_proc.r,
%   R/wtcalc.R, R/wtcalc_unit.R
\name{DBvars.default}
\alias{DBvars.default}
\alias{DBgetfn}
\alias{getspconddat}
\alias{getpfromqry}
\alias{getEvalid.ppsa}
\alias{getPlotCur}
\alias{gui_filterdf}
\alias{DBgetbyids}
\alias{DBcreateSQLite}
\alias{Ratio2Size}
\alias{addCI}
\alias{change10char}
\alias{getext}
\alias{getoutfn}
\alias{addcommas}
\alias{pastevars}
\alias{stopQ}
\alias{removecols}
\alias{DT_NAto0}
\alias{changeNULL}
\alias{getdups}
\alias{getlistparam}
\alias{getnm}
\alias{capfirst}
\alias{nbrdecimals}
\alias{nbrdigits}
\alias{getfilter}
\alias{filter2qry}
\alias{wraptitle}
\alias{xtabf}
\alias{recodelut}
\alias{findnm}
\alias{chkdbtab}
\alias{strat.pivot}
\alias{makedummy}
\alias{preds.standardize}
\alias{gregEN.select}
\alias{preds.select}
\alias{fileexistsnm}
\alias{getRefcodes}
\alias{getRefobject}
\alias{getadjfactorGB}
\alias{getadjfactorPLOT}
\alias{getfunnm}
\alias{getlt10char}
\alias{getrhat}
\alias{groupEstunit}
\alias{groupStrata}
\alias{groupUnits}
\alias{internal_desc}
\alias{save1tab}
\alias{save2tabs}
\alias{strat.collapse}
\alias{allin1f}
\alias{crosstabx}
\alias{add0unit}
\alias{addrowgrp}
\alias{crossxtab}
\alias{getdomain}
\alias{getestvar}
\alias{crossxbyunit}
\alias{ptdata2sf}
\alias{sf2ptdata}
\alias{layerIntersection}
\alias{layerUnion}
\alias{tabulateIntersections}
\alias{selectByIntersects}
\alias{layerFromRasterExtent}
\alias{vectorTranslate}
\alias{wtcalc}
\alias{wtcalc.unit}
\title{General Utility Functions}
\usage{
DBvars.default(
  istree,
  isseed,
  isveg,
  isdwm,
  issubp,
  regionVars,
  plotgeom = FALSE,
  regionVarsRS = "RMRS"
)

DBgetfn(
  tab,
  invtype,
  outfn.pre,
  stabbrlst = NULL,
  evalid = NULL,
  qry = FALSE,
  othertxt = NULL,
  outfn.date = FALSE,
  addslash = FALSE,
  ext = "csv",
  outfolder = NULL,
  overwrite = FALSE
)

getspconddat(
  cond = NULL,
  ACTUALcond = NULL,
  cuniqueid = "PLT_CN",
  condid1 = FALSE,
  ACI = FALSE
)

getpfromqry(
  dsn = NULL,
  evalid = NULL,
  plotCur = TRUE,
  varCur = "MEASYEAR",
  Endyr = NULL,
  invyrs = NULL,
  allyrs = FALSE,
  SCHEMA. = NULL,
  subcycle99 = NULL,
  designcd1 = FALSE,
  intensity1 = NULL,
  popSURVEY = FALSE,
  chk = FALSE,
  syntax = "sql",
  plotnm = "plot",
  ppsanm = "pop_plot_stratum_assgn",
  ppsaid = "PLT_CN",
  surveynm = "survey"
)

getEvalid.ppsa(
  ppsa,
  states = NULL,
  evalAll = FALSE,
  evalCur = FALSE,
  evalEndyr = NULL,
  evalType = "VOL"
)

getPlotCur(
  pltx,
  Endyr = NULL,
  varCur = "MEASYEAR",
  Endyr.filter = NULL,
  designcd1 = TRUE
)

gui_filterdf(df, byname = TRUE)

DBgetbyids(dbconn, ids, layernm, layerid = "PLT_CN")

DBcreateSQLite(
  SQLitefn = NULL,
  gpkg = FALSE,
  dbconnopen = FALSE,
  outfolder = NULL,
  outfn.pre = NULL,
  outfn.date = FALSE,
  overwrite = FALSE,
  returnpath = TRUE,
  stopifnull = FALSE
)

Ratio2Size(sumyn, ysum, sumyd, uniqueid, stratalut, unitvar, strvar, domain)

addCI(x, estnm, senm = NULL, conf.level = c(99, 95, 68), gainloss = FALSE)

change10char(xnms)

getext(x)

getoutfn(
  outfn,
  outfolder = NULL,
  outfn.pre = NULL,
  outfn.date = FALSE,
  overwrite = FALSE,
  ext = NULL,
  baseonly = FALSE,
  noext = FALSE,
  outfn.default = "outfile",
  add = TRUE,
  append = FALSE,
  gui = FALSE
)

addcommas(vars, ALIAS = NULL, sepchar = ",", quotes = FALSE, paren = FALSE)

pastevars(vars1, vars2, sep = ",")

stopQ()

removecols(x, vars)

DT_NAto0(DT, cols, changeto = 0)

changeNULL(x, xvar, changeto = NULL)

getdups(cx, cuniqueid = "PLT_CN", varnm, fun)

getlistparam(lst)

getnm(xvar, group = FALSE)

capfirst(x, allwords = FALSE)

nbrdecimals(x)

nbrdigits(x)

getfilter(att, val, syntax = "R")

filter2qry(filt, layernm)

wraptitle(x, len = 10)

xtabf(x, y, levels)

recodelut(lut, minvar = "min", maxvar = "max", classvar = "class")

findnm(x, xvect, returnNULL = FALSE)

chkdbtab(dbtablst, tab, stopifnull = FALSE)

getext(x)

getfilter(att, val, syntax = "R")

filter2qry(filt, layernm)

recodelut(lut, minvar = "min", maxvar = "max", classvar = "class")

strat.pivot(x, strvar, unitvars, strwtvar = "Prop", strat.levels = NULL)

makedummy(dat, auxlut, predfac)

preds.standardize(plt, aux, prednames)

gregEN.select(
  y,
  x_sample,
  x_pop,
  N,
  alpha = 0.5,
  returncoef = FALSE,
  cvfolds = 10
)

preds.select(y, plt, auxlut, prednames, cvfolds = 10)

fileexistsnm(outfolder, basenm, ext)

getRefcodes(xvar)

getRefobject(xvar)

getadjfactorGB(
  condx = NULL,
  treex = NULL,
  seedx = NULL,
  vcondsppx = NULL,
  vcondstrx = NULL,
  tuniqueid = "PLT_CN",
  cuniqueid = "PLT_CN",
  vuniqueid = "PLT_CN",
  condid = "CONDID",
  unitlut = NULL,
  unitvars = NULL,
  strvars = NULL,
  unitarea = NULL,
  areavar = NULL,
  areawt = "CONDPROP_UNADJ",
  cvars2keep = NULL,
  tpropvars = list(SUBP = "SUBPPROP_UNADJ", MICR = "MICRPROP_UNADJ", MACR =
    "MACRPROP_UNADJ")
)

getadjfactorPLOT(
  condx = NULL,
  treex = NULL,
  seedx = NULL,
  cuniqueid = "PLT_CN",
  tuniqueid = "PLT_CN",
  condid = "CONDID",
  checkNA = TRUE,
  areawt = "CONDPROP_UNADJ",
  tpropvars = list(SUBP = "SUBPPROP_UNADJ", MICR = "MICRPROP_UNADJ", MACR =
    "MACRPROP_UNADJ")
)

getfunnm(x)

getlt10char(dbname)

getrhat(x)

groupEstunit(x, minplotnum)

groupStrata(x, minplotnum)

groupUnits(
  tabest,
  domain,
  esttype = "AREA",
  estncol = "estn",
  estncol.var = "estn.var",
  estdcol = "estd",
  estdcol.var = "estd.var",
  covarcol = "covar",
  grpfun = sum,
  domvar2 = NULL,
  rowgrpnm = NULL,
  unitvar = NULL,
  areavar = NULL,
  phototype = "PCT",
  photoratio = FALSE,
  keepvars = NULL
)

save1tab(
  tab,
  tab.title = NULL,
  outfolder,
  allin1 = TRUE,
  coltitlerow = TRUE,
  coltitle = NULL,
  addtitle = TRUE,
  rowtotal = TRUE,
  rnames = NULL,
  outfn = NULL,
  addformat = TRUE,
  charvars = NULL,
  outfn.date = TRUE,
  overwrite = FALSE,
  cols2format = NULL
)

save2tabs(
  tab1,
  tab2,
  tab1.title,
  tab2.title,
  outfolder,
  coltitlerow = TRUE,
  coltitle = NULL,
  addtitle = TRUE,
  rowtotal = TRUE,
  rnames = NULL,
  outfn.estpse = NULL,
  outfn.date = TRUE,
  overwrite = FALSE
)

strat.collapse(
  stratacnt,
  errtab,
  pltstratx,
  minplotnum.unit = 10,
  minplotnum.strat = 2,
  unitarea,
  areavar,
  unitvar,
  unitvar2 = NULL,
  strvar,
  getwt = FALSE,
  stratcombine = TRUE,
  unitcombine = FALSE,
  vars2combine = NULL
)

allin1f(
  x,
  y,
  char.width = NULL,
  estnull = "--",
  psenull = "--",
  estround = NULL,
  pseround = NULL
)

crosstabx(
  x,
  xvar,
  estnm,
  psenm,
  allin1 = FALSE,
  char.width = NULL,
  estround = NULL,
  pseround = NULL,
  estnull = "--",
  psenull = "--"
)

add0unit(
  x,
  xvar,
  uniquex,
  unitvar = NULL,
  xvar.add0 = FALSE,
  xvar2 = NULL,
  uniquex2 = NULL,
  xvar2.add0 = FALSE
)

addrowgrp(x, uniquerow, rowvar, rowgrpnm, title.rnames = NULL)

crossxtab(
  group.est,
  rowvar.est = NULL,
  colvar.est = NULL,
  total.est = NULL,
  rowvar,
  colvar,
  estnm,
  psenm,
  estround = NULL,
  pseround = NULL,
  gtotal = TRUE,
  allin1 = FALSE,
  rowgrp = FALSE,
  rowgrpnm = NULL,
  title.rnames = NULL,
  estnull = 0,
  psenull = "--",
  char.width = NULL
)

getdomain()

getestvar()

crossxbyunit(
  unit = NULL,
  unit_grpest = NULL,
  unit_rowest = NULL,
  unit_colest = NULL,
  unit_totest = NULL,
  unitvar,
  rowvar,
  colvar,
  estnm,
  psenm,
  allin1,
  char.width,
  estnull,
  psenull,
  estround = NULL,
  pseround = NULL,
  rowgrp = NULL,
  rowgrpnm = NULL,
  title.rnames = NULL,
  numunits,
  savedata,
  addtitle,
  returntitle,
  outfn.estpse,
  title.estpse,
  title.est,
  title.pse,
  title.ref,
  outfolder,
  outfn.date,
  overwrite,
  esttype,
  phototype,
  rnames = NULL,
  title.colvar = NULL,
  title.unitvar = NULL
)

ptdata2sf(
  ptdata,
  crs,
  coords = c(2, 3),
  asSpatial = FALSE,
  stringsAsFactors = FALSE
)

sf2ptdata(ptlayer, id_fld = 1, stringsAsFactors = FALSE)

layerIntersection(
  layer1,
  layer2,
  asSpatial = FALSE,
  dropLowerDimGeom = TRUE,
  stringsAsFactors = FALSE
)

layerUnion(
  layer1,
  layer2,
  asSpatial = FALSE,
  dropLowerDimGeom = TRUE,
  sfColName = "geometry",
  stringsAsFactors = FALSE
)

tabulateIntersections(
  layer1,
  layer1fld,
  layer2,
  layer2fld = NULL,
  stringsAsFactors = FALSE,
  withUnits = FALSE
)

selectByIntersects(
  layer1,
  layer2,
  overlapThreshold = 0,
  thresholdAsPct = TRUE,
  asSpatial = FALSE,
  stringsAsFactors = FALSE
)

layerFromRasterExtent(rasterfile, asSpatial = FALSE)

vectorTranslate(
  src_dsn,
  dst_dsn,
  dst_fmt = "ESRI Shapefile",
  src_layer = NULL,
  dst_layer = NULL,
  update = FALSE,
  overwrite = FALSE,
  dsco = NULL,
  lco = NULL,
  nlt = "PROMOTE_TO_MULTI",
  t_srs = NULL,
  addOptions = NULL
)

wtcalc(wtLUT, strvar, acrevar)

wtcalc.unit(wtLUT, strvar, unit, unitvar, acrevar)
}
\value{
Object for internal use by other functions in FIESTAutils or other packages
used for USDA Forest Service data analysis.
}
\description{
These functions provide a wide-range of general utility for a variety of
data types. They were developed by the FIESTA development team and solve 
many general and specific problems for data analysis in R.
}
\details{
These functions provide a wide-range of general utility for a variety of
data types.
}
\author{
Tracey S. Frescino, Chris Toney, Grayson W. White
}
\keyword{internal}
