% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/contrast.matrix.R
\name{contrast.matrix}
\alias{contrast.matrix}
\title{Construct Contrast Matrix}
\usage{
contrast.matrix(contrast, model.matrix.names)
}
\arguments{
\item{contrast}{A vector of character strings specifying the various comparisons, which are the expressions constituted by model.matrix.names.}

\item{model.matrix.names}{Column names of model (design) matrix.}
}
\value{
Matrix which columns correspond to contrasts.
}
\description{
Construct the contrast matrix to make various comparsions of different treatments.
}
\examples{
model_variables <- c("A", "B", "C", "D")
contrast <- c("AvsB" = "A-B", "AvsC" = "A-C", 'AvsB.C.D'= "A-(B+C+D)/3")
contrast.matrix(contrast, model_variables)

}
