% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/WalleyeConsumption.R
\docType{data}
\name{WalleyeConsumption}
\alias{WalleyeConsumption}
\title{Consumption of prey by Walleye.}
\format{
A data frame of 23 observations on the following 2 variables:
 \describe{
   \item{PreyDensity}{Density of prey (mg per g per day).}
   \item{FoodConsump}{Food consumption by predator (mg per cubic meter)} 
 }
}
\source{
From Figure 3 in Madenjian, C.P., and S.R. Carpenter. 1991. Individual-based model for growth of young-of-the-year walleye: A piece of the recruitment puzzle. Ecological Applications 1:268-279. Data were originally from Swenson, W. A. 1977. Food consumptions of walleye (\emph{Stizostedion vitreum vitreum}) and sauger (\emph{S. canadense}) in relation to food availability and physical conditions in Lake of the Woods, Minnesota, Shagawa Lake, and western Lake Superior. Journal of the Fisheries Research Board of Canada 34:1643-1654. \href{https://raw.githubusercontent.com/fishR-Core-Team/FSAdata/main/data-raw/WalleyeConsumption.csv}{CSV file}
}
\description{
Consumption of prey by Walleye (\emph{Sander vitreus}) at different prey densities.
}
\section{Topic(s)}{

 \itemize{
   \item Nonlinear modeling 
 }
}

\examples{
data(WalleyeConsumption)
str(WalleyeConsumption)
head(WalleyeConsumption)
plot(FoodConsump~PreyDensity,data=WalleyeConsumption,pch=16)

}
\keyword{datasets}
