\name{plot.simfam}
\alias{plot.simfam}
\title{Plot pedigrees}
\description{
Plot method for \code{simfam}. Provides pedigree plots for specified families generated from \code{simfam} function with option to save plots into a pdf file.
}
\usage{
\method{plot}{simfam}(x, famid, pdf=FALSE, file=NULL, \ldots)
}
\arguments{
 \item{x}{Object created by \code{simfam} function, or a data frame that contains \code{famID},\code{indID},\code{fatherID}, \code{motherID},\code{gender} (1 for male, 0 for female),\code{status} (1 for affected, 0 for non-affected), \code{mgene} (1 for mutation carrier, 0 for non-carrier), and \code{proband} (1 for proband, 0 for non-proband). Optionally, data frame can contain a column named \code{carrp} or \code{carrp.pheno} to replace missing values in \code{mgene} to their carrier probabilities.
}
 \item{famid}{List of family IDs to plot. Default is the first family in given data set}
 \item{pdf}{logical; if TRUE, pedigree plots are saved in a pdf file. If FALSE, plot pedigrees on current plotting device. Default=FALSE.}
 \item{file}{File name to save the pedigree plots; Default file name is "pedigreeplot.pdf".}
 \item{...}{Additional arguments passed on to the plot function.}
 
}

\value{
Returns pedigree plots for specified families created by \code{\link{simfam}} function or dataframe provided along with the affection and carrier mutation statuses of family members. Probands from each pedigree are indicated using red color.

When dataframe inlcudes \code{carrp} or \code{carrp.pheno} generated by \code{\link{carrierprobgeno}} or \code{\link{carrierprobpheno}} functions, the plot function displays the carrier probabilities for those with missing carrier status.
}

\seealso{
\code{\link{simfam}, \link{summary.simfam}, \link{carrierprobgeno}, \link{carrierprobpheno}}	
}

\examples{

# Simulated family data

fam <- simfam(N.fam=300, design="pop+", variation="secondgene", 
       base.dist="Weibull", allelefreq=c(0.02, 0.2), 
       base.parms=c(0.01,3), vbeta=c(-1.13, 2.35, 0.5), agemin=20)
 
# Pedigree plots for first five simulated families

plot.simfam(fam, famid=c(1:5), pdf=TRUE, file="pedigrees.pdf")
	
}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{ Pedigree plot }
