% Generated by roxygen2 (4.0.1): do not edit by hand
\name{estimkienerX}
\alias{estimkienerX}
\alias{estimkienerX5}
\alias{estimkienerX7}
\title{Parameter estimation for Kiener Distributions}
\usage{
estimkienerX(X, ord = 7, type = 6, maxk = 10, parnames = TRUE)

estimkienerX7(X, dgts = 0, parnames = TRUE)

estimkienerX5(X, dgts = 0, parnames = TRUE)
}
\arguments{
\item{X}{numeric. Vector of quantiles.}

\item{ord}{integer. Option for quantile selection and treatment.}

\item{type}{integer. Option passed to the \code{\link{quantile}} function.}

\item{maxk}{numeric. Maximum allowed value for k (kappa).}

\item{parnames}{boolean. Parameter vector with or without names.}

\item{dgts}{integer. The number of rounded digits.}
}
\value{
A vector of estimated parameters code{c(m, g, a, k, w, d, e)} with
rounded values \code{digits = c(3, 3, 1, 1, 1, 3, 2) + dgts)}.
}
\description{
A fast parameter estimation for Kiener distributions of type K2, K3 and K4.




}
\details{
Asymetric Kiener distributions of type K2, K3, K4 can be estimated with just
5 quantiles : the median x.50, two quantiles around the median, usually x.35
and x.65 or better x.25 and x.75, two quantiles located just before the extremes
of the dataset, for instance x.01 and x.99 if the dataset \code{X} has more
than 100 points, x.0001 and x.9999 if the dataset \code{X} has more than
10.000 points.

For averaging purpose, calculation can be done from 5 to 11 probability levels
\code{c(1-p1, 1-p2, 1-p3, 0.25, 0.35, 0.50, 0.65, 0.75, p3, p2, p1)}
extracted from \code{X} with the function \code{\link{elevenprobs}}.
p1, p2 and p3 are the most extreme probabilities of the dataset \code{X}
with values finishing either by \code{pp950} or \code{pp975} or \code{pp990}.
The corresponding quantiles, extracted with the standard function
\code{\link{quantile}} are then transfered to \code{\link{estimkiener11}}.
\code{estimkienerX} and \code{estimkienerX5} are wrappers of these functions.

The probability and quantile selection among these 11 values is controlled
with the option \code{ord} which can take 12 integer values,
\code{ord = 7} being the default:
\itemize{
  \item{ 1: c(1-p1, 0.35, 0.50, 0.65, p1)}
  \item{ 2: c(1-p2, 0.35, 0.50, 0.65, p2)}
  \item{ 3: c(1-p1, 1-p2, 0.35, 0.50, 0.65, p2, p1)}
  \item{ 4: c(1-p1, 1-p2, 1-p3, 0.35, 0.50, 0.65, p3, p2, p1)}
  \item{ 5: c(1-p1, 0.25, 0.50, 0.75, p1)}
  \item{ 6: c(1-p2, 0.25, 0.50, 0.75, p2)}
  \item{ 7: c(1-p1, 1-p2, 0.25, 0.50, 0.75, p2, p1)}
  \item{ 8: c(1-p1, 1-p2, 1-p3, 0.25, 0.50, 0.75, p3, p2, p1)}
  \item{ 9: c(1-p1, 0.25, 0.35, 0.50, 0.65, 0.75, p1)}
  \item{10: c(1-p2, 0.25, 0.35, 0.50, 0.65, 0.75, p2)}
  \item{11: c(1-p1, 1-p2, 0.25, 0.35, 0.50, 0.65, 0.75, p2, p1)}
  \item{12: c(1-p1, 1-p2, 1-p3, 0.25, 0.35, 0.50, 0.65, 0.75, p3, p2, p1)}
}

The option \code{type} used by \code{\link{quantile}} can change significantly
the results. Our experience is that \code{type = 6} is appropriate when
\code{k > 1.9} and \code{type = 5} is appropriate when \code{k < 1.9}.
Other types \code{type = 8} and \code{type = 9} can be considered as well.
The other types should be ignored.

Parameter maxk controls the maximum allowed value for estimated parameter k.
Reasonnable values are \code{maxk = 10, 15, 20}. Default is \code{maxk = 10}
to be consistent with \code{\link{regkienerLX}}.

\code{estimkienerX5} is a simplified function with predifined values ord = 5,
type = 6, rounded digits \code{digits = c(3, 3, 1, 1, 1, 3, 2) + dgts)}
and parameters names \code{c("m", "g", "a", "k", "w", "d", "e")} that can
be omitted if \code{parnames = FALSE}.

When \code{a, k, w < 1.4}, the estimates become less accurate and the function
\code{\link{regkienerLX}} should rather be preferred.
}
\examples{
require(timeSeries)

## Choose j in 1:16
DS   <- getDSdata()
j    <- 5
elevenprobs(DS[[j]])
round(estimkienerX(DS[[j]]), 3)
round(t(sapply(DS, estimkienerX)), 3)
t(sapply(DS, estimkienerX5))
## end
}
\references{
P. Kiener, Fat tail analysis and package FatTailsR - Season 2,
9th R/Rmetrics Workshop and Summer School, Zurich, 27 June 2015.
Download it from:
\url{http://www.inmodelia.com/exemples/2015-0627-Rmetrics-Kiener-en.pdf}
}
\seealso{
\code{\link{regkienerLX}}, \code{\link{fitkienerLX}}.
}

