% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NED_FUNCTIONS.R
\name{get_ned_tile}
\alias{get_ned_tile}
\title{Download and crop tile from the 1 (~30 meter) or 1/3 (~10 meter) arc-second National Elevation Dataset.}
\usage{
get_ned_tile(template = NULL, res = "1", tileNorthing, tileWesting, raw.dir)
}
\arguments{
\item{template}{A Raster* or Spatial* object to serve 
as a template for cropping. If missing, entire tile is returned.}

\item{res}{A character string representing the desired resolution of the NED. "1"
indicates the 1 arc-second NED (the default), while "13" indicates the 1/3 arc-second dataset.}

\item{tileNorthing}{An integer representing the northing (latitude, in degrees north of the equator) of the northwest corner of the tile to 
be downloaded.}

\item{tileWesting}{An integer representing the westing (longitude, in degrees west of the prime meridian) of the northwest corner of the tile to 
be downloaded.}

\item{raw.dir}{A character string indicating where raw downloaded files should be put.
The directory will be created if missing. Defaults to "./RAW/NED/".}
}
\value{
A \code{RasterLayer} cropped within the specified \code{template}.
}
\description{
\code{get_ned_tile} returns a \code{RasterLayer} cropped within the specified \code{template}.
If template is not provided, returns the entire NED tile.
}
\keyword{internal}

