% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fct_incomplete_blocks.R
\name{incomplete_blocks}
\alias{incomplete_blocks}
\title{Generates a Resolvable Incomplete Block Design}
\usage{
incomplete_blocks(
  t = NULL,
  k = NULL,
  r = NULL,
  l = 1,
  plotNumber = 101,
  locationNames = NULL,
  seed = NULL,
  data = NULL
)
}
\arguments{
\item{t}{Number of  treatments.}

\item{k}{Size of incomplete blocks (number of units per incomplete block).}

\item{r}{Number of full blocks (or resolvable replicates) (also number of replicates per treatment).}

\item{l}{Number of locations. By default \code{l = 1}.}

\item{plotNumber}{Numeric vector with the starting plot number for each location. By default \code{plotNumber = 101}.}

\item{locationNames}{(optional) Names for each location.}

\item{seed}{(optional) Real number that specifies the starting seed to obtain reproducible designs.}

\item{data}{(optional) Data frame with label list of treatments.}
}
\value{
A list with two elements.
\itemize{
  \item \code{infoDesign} is a list with information on the design parameters.
  \item \code{fieldBook} is a data frame with the incomplete block design field book.
}
}
\description{
Randomly generates a resolvable incomplete block design (IBD) of characteristics (t, k, r).
The randomization can be done across locations.
}
\examples{
# Example 1: Generates a resolvable IBD of characteristics (t,k,r) = (12,4,2).
# 1-resolvable IBDs
ibd1 <- incomplete_blocks(t = 12,
                          k = 4,
                          r = 2,
                          seed = 1984)
ibd1$infoDesign
head(ibd1$fieldBook)

# Example 2: Generates a balanced resolvable IBD of characteristics (t,k,r) = (15,3,7).
# In this case, we show how to use the option data.
treatments <- paste("TX-", 1:15, sep = "")
ENTRY <- 1:15
treatment_list <- data.frame(list(ENTRY = ENTRY, TREATMENT = treatments))
head(treatment_list)
ibd2 <- incomplete_blocks(t = 15,
                          k = 3,
                          r = 7,
                          seed = 1985,
                          data = treatment_list)
ibd2$infoDesign
head(ibd2$fieldBook)

}
\references{
Edmondson., R. N. (2021). blocksdesign: Nested and crossed block designs for factorial and
unstructured treatment sets. https://CRAN.R-project.org/package=blocksdesign
}
\author{
Didier Murillo [aut],
        Salvador Gezan [aut],
        Ana Heilman [ctb],
        Thomas Walk [ctb], 
        Johan Aparicio [ctb], 
        Richard Horsley [ctb]
}
