% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/06.2.Efficiency.R
\name{network.efficiency}
\alias{network.efficiency}
\title{Calculate network efficiency}
\usage{
network.efficiency(
  ...,
  ignore.weights = FALSE,
  use.igraph = isTRUE(requireNamespace("igraph", quietly = TRUE))
)
}
\arguments{
\item{...}{Firm-Firm network in one of the following classes:
\itemize{
 \item{\code{financial_matrix} produced by \code{FF} and family;}
 \item{\code{network_financial} or \code{network} if the relevant package is installed;}
 \item{\code{igraph_financial} or \code{igraph} if the  relevant package is installed.}
}}

\item{ignore.weights}{Optional parameter, defaults to \code{FALSE}. If \code{TRUE}, ignore ties weights in the computation.}

\item{use.igraph}{Whether to use igraph to speed-up the computation. See 'Details'.}
}
\value{
A \code{numeric}, the global efficiency value.
}
\description{
Network efficiency quantifies how efficiently information (management relations)
and/or money capital (ownership relations) flow through a network. It is essential in
systemic-risk identification, resilience assessment, and crisis-propagation analysis.
}
\details{
The function is implemented both for \code{igraph} users and in base \code{R} using the Floyd-Warshall algorithm.
However, the latter runs in \eqn{O(n^3)}, which may not be efficient for very large networks.

The distances enter into play in the formal definition of efficiency:

\deqn{E = \frac{1}{N(N-1)}\sum_{i\ne j \in \mathcal{N}}\frac{1}{d_{i,\ j}}}

where:
\itemize{
 \item{\eqn{\mathcal{N}} is the set of all nodes};
 \item{\eqn{N} is the number of nodes (i.e., the number of elements in \eqn{\mathcal{N}};}
 \item{\eqn{d_{i,\ j}} is the shortest (weighted and directed) path distance between the nodes \eqn{i} and \eqn{j}.}
}
}
\examples{
# Load some data
data('firms_BKB')

# Create a FF matrix
mat <- FF(firms_BKB, who = 'b', ties =  'n')
# Use the built-in Floyd-Warshall algorithm
network.efficiency(mat, use.igraph = FALSE)

#' # Create a FF graph
if(!require('igraph')){
  g <- FF.graph(mat, 'simple')
  # Use igraph's implementation, which gives the same result
  # as the built-in Floyd-Warshall algorithm, but is faster
  network.efficiency(g, use.igraph = TRUE)==network.efficiency(mat, use.igraph = FALSE)
}

}
\references{
Latora, Vito, and Masimo Marchiori. 'Economic Small-World Behavior in Weighted Networks'. The European Physical Journal B - Condensed Matter and Complex Systems 32, no. 2 (1 March 2003): 249–63. \doi{10.1140/epjb/e2003-00095-5}.

Floyd, Robert W. 'Algorithm 97: Shortest path'. Communications of the ACM, 5, no. 6 (1962): 345.
}
\author{
\enc{Telarico, Fabio Ashtar}{Fabio Ashtar Telarico}
}
