% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FSFDR.R
\name{FSFDR.indept.cv}
\alias{FSFDR.indept.cv}
\title{Critical Values for Fixed Sequence FDR Controlling Procedures under Independence}
\usage{
FSFDR.indept.cv(p, k=1, alpha = 0.05, tol = 1e-6, make.decision = TRUE)
}
\arguments{
\item{p}{numeric vector of p-values (possibly with \code{\link[base]{NA}}s). Any other R is coerced by \code{\link[base]{as.numeric}}. Same as in \code{\link[stats]{p.adjust}}.}

\item{k}{pre-specified number of acceptances allowed in the testing procedure (cannot exceed the length of \code{p})}

\item{alpha}{significant level used to calculate the critical values to make decisions, the default value is 0.05.}

\item{tol}{desired accuracy. The default value is \code{1e-6 }.}

\item{make.decision}{logical; if  \code{TRUE} (default), then the output include the decision rules compared adjusted p-values with significant level \eqn{alpha}}
}
\value{
A numeric vector of the critical values (of the same length as \code{p}) if  \code{make.decision = FALSE}, or  a data frame including original p-values, critical values and decision rules if \code{make.decision = TRUE}.
}
\description{
Given a set of pre-ordered p-values and accuracy for the result, returns critical values using the generalized fixed sequence multiple testing procedures under independence for true nulls (See Theorem 3.2 and 4.2 in Lynch et al. (2016)). The function also provides an option to make decisions given a pre-specified significant level \eqn{\alpha}.
}
\examples{
## generate a pre-ordered pvalue vector for 50 hypotheses, where 60\% are true nulls
set.seed(1234); n <- 50; pi0 <- 0.6
mu <- sample(c(0,3), n, replace = TRUE, prob = c(pi0,1-pi0))
Zstat <- rnorm(n = n, mean = mu)
Pval <- 1-pnorm(Zstat)
## conventional fixed sequence procedure
FSFDR.indept.cv(p = Pval, alpha = 0.05)
## generalized fixed sequence procedure allowing stop at 5th acceptance
FSFDR.indept.cv(p = Pval, alpha = 0.05, k=5)
}
\author{
Yalin Zhu
}
\references{
Lynch, G., Guo, W., Sarkar, S. K., & Finner, H. (2016).
 The Control of the False Discovery Rate in Fixed Sequence Multiple Testing.
 \emph{arXiv preprint} arXiv:1611.03146.
}
\seealso{
\code{\link{FSFWER.arbidept.cv}}  for fixed sequence FWER controlling procedures.
}

