% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/function-calculateWeights.R
\docType{methods}
\name{calculateWeights_old_methods}
\alias{FuzzyPairwiseComparisonMatrix-method,}
\alias{calculateWeights_old_methods}
\alias{calculateWeights_old_methods,}
\alias{calculateWeights_old_methods,FuzzyPairwiseComparisonMatrix-method}
\alias{character-method}
\title{Function to calculate fuzzy weights based on comparison matrix using older approaches}
\usage{
calculateWeights_old_methods(comparisonMatrix, type = "Chang")


  \S4method{calculateWeights_old_methods}{FuzzyPairwiseComparisonMatrix}(comparisonMatrix,
  type = "Chang")
}
\arguments{
\item{comparisonMatrix}{object of \linkS4class{FuzzyPairwiseComparisonMatrix}}

\item{type}{A \code{"character"} representing type of method used for weights or fuzzy weights
determination. Currently implemented methods are
\code{"Chang"}, \code{"Wang"} and \code{"Tesfamariam"}. The default value is \code{"Chang"}.}
}
\value{
\code{\linkS4class{FuzzyWeights}}. If fuzzy weighting vector is to be obtained
please see \code{\link{calculate_weighting_vector}} function.
}
\description{
This functions calculates \code{\linkS4class{FuzzyWeights}}
based on input fuzzy pairwise comparison matrix.
}
\references{
CHANG, Da-Yong, 1996, Applications of the extent analysis method on fuzzy AHP. European Journal of Operational Research. 1996. Vol. 95, no. 3, p. 649–655. DOI 10.1016/0377-2217(95)00300-2.

TESFAMARIAM, Solomon and SADIQ, Rehan, 2006, Risk-based environmental decision-making using fuzzy analytic hierarchy process (F-AHP). Stochastic Environmental Research and Risk Assessment. 2006. Vol. 21, no. 1, p. 35–50. DOI 10.1007/s00477-006-0042-9.

WANG, Tien-Chin and CHEN, Yueh-Hsiang, 2008, Applying fuzzy linguistic preference relations to the improvement of consistency of fuzzy AHP. Information Sciences [online]. October 2008. Vol. 178, no. 19, p. 3755–3765. DOI 10.1016/j.ins.2008.05.028.
}
\seealso{
\code{\link{calculate_weighting_vector}}
}

