% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FuzzyDBScan.R
\name{Fuzzy_DBScan}
\alias{Fuzzy_DBScan}
\alias{FuzzyDBScan}
\title{Fuzzy DBScan}
\description{
This object implements fuzzy DBScan with both, fuzzy cores and fuzzy borders.
Additionally, it provides a predict function.
}
\details{
A method to initialize and run the algorithm and a function
to predict new data.
The package is build upon the paper
"Fuzzy Extensions of the DBScan algorithm" from Ienco and Bordogna.
The predict function assigns new data based on the same criteria as the
algorithm itself.
However, the prediction function freezes the algorithm to preserve the
trained cluster structure and treats each new prediction object individually.
Note, that border points are included to the cluster.
}
\examples{
# load factoextra for data and ggplot for plotting
library(factoextra)
dta = multishapes[, 1:2]
eps = c(0, 0.2)
pts = c(3, 15)
# train DBScan based on data, ep and pts
cl = FuzzyDBScan$new(dta, eps, pts)
# Plot DBScan for x and y
library(ggplot2)
cl$plot("x", "y")
# produce test data
x <- seq(min(dta$x), max(dta$x), length.out = 50)
y <- seq(min(dta$y), max(dta$y), length.out = 50)
p_dta = expand.grid(x = x, y = y)
# predict on test data and plot results
p = cl$predict(p_dta, FALSE)
ggplot(p, aes(x = p_dta[, 1], y = p_dta[, 2], colour = as.factor(cluster))) +
  geom_point(alpha = p$dense)
}
\references{
Ienco, Dino, and Gloria Bordogna.
Fuzzy extensions of the DBScan clustering algorithm.
Soft Computing 22.5 (2018): 1719-1730.
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{dta}}{\link{data.frame} | \link{matrix}\cr
The data to be clustered by the algorithm. Allowed
are only \link{numeric} columns.}

\item{\code{eps}}{\link{numeric}\cr
The size (radius) of the epsilon neighborhood.
If  the radius contains 2 numbers, the fuzzy cores
are calculated between the minimum and the maximum
radius.
If epsilon is a single number, the algorithm
looses the fuzzy core property. If the length of
\code{pts} is also 1L, the algorithm equals to non-fuzzy
DBScan.}

\item{\code{pts}}{\link{numeric}\cr
number of maximum and minimum points required in the
\code{eps}  neighborhood for core points (excluding the
point itself). If the length of the argument is 1,
the algorithm looses its fuzzy border property. If
the length of \code{eps} is also 1L, the algorithm equals
to non-fuzzy DBScan.}

\item{\code{clusters}}{\link{factor}\cr
Contains the assigned clusters per observation in
the same order as in \code{dta}.}

\item{\code{dense}}{\link{numeric}\cr
Contains the assigned density estimates per
observation in the same order as in \code{dta}.}

\item{\code{point_def}}{\link{character}\cr
Contains the assigned definition estimates per
observation in the same order as in \code{dta}. Possible
are "Core Point", "Border Point" and "Noise".}

\item{\code{results}}{\link{data.table}\cr
A table where each column indicates for the
probability of the new data to belong to a
respective cluster.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-FuzzyDBScan-new}{\code{FuzzyDBScan$new()}}
\item \href{#method-FuzzyDBScan-predict}{\code{FuzzyDBScan$predict()}}
\item \href{#method-FuzzyDBScan-plot}{\code{FuzzyDBScan$plot()}}
\item \href{#method-FuzzyDBScan-clone}{\code{FuzzyDBScan$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FuzzyDBScan-new"></a>}}
\if{latex}{\out{\hypertarget{method-FuzzyDBScan-new}{}}}
\subsection{Method \code{new()}}{
Create a FuzzyDBScan object. Apply the
fuzzy DBScan algorithm given the data \code{dta}, the
range of the radius \code{eps} and the range of the
Points \code{pts}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FuzzyDBScan$new(dta, eps, pts)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{dta}}{\link{data.frame} | \link{matrix}\cr
The data to be clustered by the algorithm. Allowed
are only \link{numeric} columns.}

\item{\code{eps}}{\link{numeric}\cr
The size (radius) of the epsilon neighborhood.
If  the radius contains 2 numbers, the fuzzy cores
are calculated between the minimum and the maximum
radius.
If epsilon is a single number, the algorithm
looses the fuzzy core property. If the length of
\code{pts} is also 1L, the algorithm equals to non-fuzzy
DBScan.}

\item{\code{pts}}{\link{numeric}\cr
number of maximum and minimum points required in the
\code{eps}  neighborhood for core points (excluding the
point itself). If the length of the argument is 1,
the algorithm looses its fuzzy border property. If
the length of \code{eps} is also 1L, the algorithm equals
to non-fuzzy DBScan.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FuzzyDBScan-predict"></a>}}
\if{latex}{\out{\hypertarget{method-FuzzyDBScan-predict}{}}}
\subsection{Method \code{predict()}}{
Predict new data with the initialized
algorithm.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FuzzyDBScan$predict(new_data, cmatrix = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{new_data}}{\link{data.frame} | \link{matrix}\cr
The data to be predicted by the algorithm. Allowed
are only \link{numeric} columns which should match to
\code{self$dta}.}

\item{\code{cmatrix}}{\link{logical}\cr
Indicating whether the assigned cluster should be
returned in form of a matrix where each column
indicates for the probability of the new data to
belong to a respective cluster. The object will have
the same shape as the \code{results} field. If set to
\code{FALSE} the shape of the returned assigned clusters
is a two-column \link{data.table} with one column
indicating the assigned cluster and the second
column indicating the respective probability of
the new data.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FuzzyDBScan-plot"></a>}}
\if{latex}{\out{\hypertarget{method-FuzzyDBScan-plot}{}}}
\subsection{Method \code{plot()}}{
Plot clusters and soft labels on two
features.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FuzzyDBScan$plot(x, y)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{\link{character}\cr
Feature to plot on the x-axis.}

\item{\code{y}}{\link{character}\cr
Feature to plot on the y-axis.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FuzzyDBScan-clone"></a>}}
\if{latex}{\out{\hypertarget{method-FuzzyDBScan-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FuzzyDBScan$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
